package org.simantics.utils.ui.color;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog extends Dialog{
	protected ColorComposite colorComposite;
	protected Color value;
	
	public ColorDialog(Shell parentShell) {
		super(parentShell);	
	}
	
	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("Color");
	}

	
	public void setInitialValue(Color initialValue) {
		this.value = new Color(initialValue);
	}
	
	@Override
    protected Point getInitialSize() {
        return new Point(400, 400);
    }
	
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayoutFactory.fillDefaults().numColumns(1).margins(6, 0).applyTo(composite);
		GridDataFactory.fillDefaults().grab(true, false).align(SWT.FILL, SWT.TOP).applyTo(composite);
		colorComposite = new ColorComposite(composite, 0);
        GridData childData = new GridData(GridData.FILL_BOTH);
        colorComposite.setLayoutData(childData); 
        if (value != null)
        	colorComposite.setColor(value);
        Group builtinGroup = new Group(composite, SWT.NONE);
        builtinGroup.setText("System colors");
        GridLayoutFactory.fillDefaults().numColumns(8).spacing(2, 2).margins(4, 4).applyTo(builtinGroup);
        for (int i = SWT.COLOR_WHITE; i <= SWT.COLOR_DARK_GRAY; i++) {
        	org.eclipse.swt.graphics.Color c = Display.getCurrent().getSystemColor(i);
        	Color color = new Color(c.getRGB());
        	createColorButton(builtinGroup, color);
        }
        

        return composite;
	}
	
	protected Button createColorButton(Composite parent, Color color) {
		Button button = new Button(parent, SWT.PUSH);
    	button.setImage(ColorIconCreator.createImage(color, 32, SWT.BORDER));
    	button.setData(color);
    	button.addSelectionListener(new SelectionAdapter() {
    		@Override
    		public void widgetSelected(SelectionEvent e) {
    			colorComposite.setColor(color);
    		}
		});
    	return button;
	}

	
	public Color getColor() {
		return colorComposite.getColor();
	}
	

}
