/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.action;

import org.eclipse.jface.action.IAction;

/**
 * An IAction with the addition of a priority specification for providing a way
 * of choosing one among multiple actions automatically or sorting multiple
 * actions based on their relatedness.
 * 
 * @author Tuukka Lehtonen
 */
public interface IPriorityAction extends IAction, Comparable<IPriorityAction> {

    int LOW = -500;

    int NORMAL = 0;

    int MEDIUM = 500;

    int HIGH   = 1000;

    /**
     * @return a priority for this IAction, bigger stands for higher priority
     */
    public int getPriority();
    
}
