/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.graph.contributor.labeler.LabelDecoratorContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.ui.modelBrowser.nodes.ComponentNode;

public class ComponentLabelDecorator extends LabelDecoratorContributor<ComponentNode> {

    static ColorDescriptor RED = null;

    public static ColorDescriptor getRED() {
        if (RED == null)
            RED = ColorDescriptor.createFrom(new RGB(255, 0, 0));
        return RED;
    }

    @Override
    public LabelDecorator getDecorator(ReadGraph g, ComponentNode node) throws DatabaseException {

        ModelingResources mr = ModelingResources.getInstance(g);
        if (!g.hasStatement(node.resource, mr.ComponentToElement)) {
            return new LabelDecorator.Stub() {
                @SuppressWarnings("unchecked")
                @Override
                public <C> C decorateForeground(C color, String column, int itemIndex) {
                    return (C) getRED();
                }
            };
        }

        return null;

    }

}
