/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.swt.ImagerContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;
import org.simantics.ui.icons.ImageDescriptorProvider;

public class AbstractNodeImager extends ImagerContributor<AbstractNode> {

    @Override
    public ImageDescriptor getDescriptor(ReadGraph graph, AbstractNode node) throws DatabaseException {
        if (!graph.hasStatement(node.resource))
            return null;
        ImageDescriptorProvider provider = graph.getPossibleAdapter(node.resource, ImageDescriptorProvider.class);
        return provider != null ? provider.get() : null;
    }

}
