package org.simantics.selectionview;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

/**
 * @author Tuukka Lehtonen
 */
public class VariableColoringDecorationRule implements LabelDecorationRule {

	private final static ColorDescriptor READONLY_GRAY = ColorDescriptor.createFrom(new RGB(240, 240, 240));

	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(Variable.class);
	}

	@Override
	public LabelDecorator getLabelDecorator(ReadGraph graph, Object content)
			throws DatabaseException {
		Variable variable = (Variable)content;
		Object o = variable.getPossiblePropertyValue(graph, Variables.READONLY);
		if (!Boolean.TRUE.equals(o))
			return null;
		return ReadOnlyDecorator.INSTANCE;
	}

	private static class ReadOnlyDecorator extends LabelDecorator.Stub {
		public static ReadOnlyDecorator INSTANCE = new ReadOnlyDecorator();
		@SuppressWarnings("unchecked")
		@Override
		public <C> C decorateBackground(C color, String column, int itemIndex) {
			if (ColumnKeys.DISPLAY_VALUE.equals(column) || ColumnKeys.DISPLAY_UNIT.equals(column))
				return (C) READONLY_GRAY;
			return null;
		}
	}

}
