package org.simantics.selectionview;


/**
 * @author Tuukka Lehtonen
 */
public class TabChangeEvent {

    private final IPropertyTab oldTab;
    private final String       oldTabLabel;
    private final IPropertyTab newTab;
    private final String       newTabLabel;

    /**
     * @param oldTab
     * @param oldTabLabel
     * @param newTab
     * @param newTabLabel
     */
    public TabChangeEvent(IPropertyTab oldTab, String oldTabLabel, IPropertyTab newTab, String newTabLabel) {
        this.oldTab = oldTab;
        this.oldTabLabel = oldTabLabel;
        this.newTab = newTab;
        this.newTabLabel = newTabLabel;
    }

    /**
     * @return <code>null</code> if no tab is currently selected or no tabs
     *         exist
     */
    public IPropertyTab getNewTab() {
        return newTab;
    }

    /**
     * @return <code>null</code> if no tab is currently selected or no tabs
     *         exist
     */
    public String getNewTabLabel() {
        return newTabLabel;
    }

    /**
     * @return <code>null</code> if no tab was previously selected
     */
    public IPropertyTab getOldTab() {
        return oldTab;
    }

    /**
     * @return <code>null</code> if no tab was previously selected
     */
    public String getOldTabLabel() {
        return oldTabLabel;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "(" + oldTabLabel + " - " + oldTab + " => " + newTabLabel + " - " + newTab + ")";
    }

}
