/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.db.management.ISessionContext;

/**
 * @author Tuukka Lehtonen
 * 
 * @see PropertyTabAdapter
 * @see PropertyTabContributorImpl
 */
public interface IPropertyTab {

    /**
     * Creates the SWT control for this page under the given parent
     * control.
     * <p>
     * Clients should not call this method (the workbench calls this method when
     * it needs to, which may be never).
     * </p>
     *
     * @param parent the parent control
     */
    void createControl(Composite parent, ISessionContext context);

    /**
     * Notifies that the container of the tab has been disposed.
     * 
     * <p>
     * Note, this means that any Dispose-listeners attached to SWT controls
     * created for this tab have been invoked before this already.
     * </p>
     * <p>
     * Also note that there is no guarantee that
     * {@link #createControl(Composite, ISessionContext)} has been called before
     * this method so the control may never have been created.
     * </p>
     */
    void dispose();

    /**
     * @return <code>true</code> if this tab has been disposed either through
     *         {@link #dispose()} or internally by the UI toolkit
     */
    boolean isDisposed();

    /**
     * @return the main UI control created by this tab
     */
    Control getControl();

    /**
     * Must be invoked from the SWT UI thread.
     * 
     * @param selection the new selection
     * @param force <code>true</code> to force the resetting of the new input
     *        even if it is the same as the previous one.
     */
    void setInput(ISessionContext context, ISelection selection, boolean force);

    /**
     * Returns the selection provider for this property tab. It shall provide
     * the currently active selection for this tab. If the tab does not wish to
     * provide its selection to external parties, <code>null</code> may be
     * returned. The selections must be instances of
     * {@link IStructuredSelection}.
     * 
     * @return structured selection provider or <code>null</code> if no
     *         selection is provided
     */
    ISelectionProvider getSelectionProvider();

    /**
     * Requests this property tab to transfer UI focus to itself.
     */
    void requestFocus();

}