package org.simantics.platform.ui;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class PlatformUIResource {
    
    public final Resource Configuration;
    public final Resource Model;
    public final Resource NameLabelMode;
    public final Resource NameLabelMode_Label;
    public final Resource NameLabelMode_LabelAndName;
    public final Resource NameLabelMode_Name;
    public final Resource NameLabelMode_NameAndLabel;
    public final Resource SCLMain;
    public final Resource SharedOntology;
    public final Resource StandardElementProperties;
    public final Resource StandardPropertiesTabContribution;
    public final Resource Views;
    public final Resource Views_AvailableColumns;
    public final Resource Views_RangeSelectionTab;
    public final Resource Views_RangeSelectionTabContribution;
    public final Resource Views_RangeSelectionTab_Cell1;
    public final Resource Views_RangeSelectionTab_Cell2;
    public final Resource Views_RangeSelectionTab_Combo;
    public final Resource Views_RangeSelectionTab_Panel;
    public final Resource Views_RangeSelectionTab_Root;
    public final Resource Views_RangeSelectionTab_Text;
    public final Resource Views_SCLValue;
    public final Resource Views_SharedLibraries;
    public final Resource Views_SharedLibraries_AvailableContext;
    public final Resource Views_SharedLibraries_AvailableContext_Children;
    public final Resource Views_SharedLibraries_AvailableContext_Children_Rule;
    public final Resource Views_SharedLibraries_Cell1;
    public final Resource Views_SharedLibraries_Cell2;
    public final Resource Views_SharedLibraries_Cell3;
    public final Resource Views_SharedLibraries_Cell4;
    public final Resource Views_SharedLibraries_Cell5;
    public final Resource Views_SharedLibraries_Cell6;
    public final Resource Views_SharedLibraries_DefVar;
    public final Resource Views_SharedLibraries_DefVar2;
    public final Resource Views_SharedLibraries_Explorer1;
    public final Resource Views_SharedLibraries_Explorer2;
    public final Resource Views_SharedLibraries_ImportButton;
    public final Resource Views_SharedLibraries_LinkButton;
    public final Resource Views_SharedLibraries_NewButton;
    public final Resource Views_SharedLibraries_Panel;
    public final Resource Views_SharedLibraries_Panel2;
    public final Resource Views_SharedLibraries_Root;
    public final Resource Views_SharedLibraries_UnlinkButton;
    public final Resource Views_SharedLibraries_UnlinkEvent;
    public final Resource Views_SharedLibraries_UseEvent;
    public final Resource Views_SharedLibraries_UsedContext;
    public final Resource Views_SharedLibraries_UsedContext_Children;
    public final Resource Views_SharedLibraries_UsedContext_Children_Rule;
    public final Resource Views_SharedLibraryContribution;
    public final Resource Views_UsedColumns;
    public final Resource Views_ValidationContribution;
    public final Resource Views_Validations;
    public final Resource Views_Validations_BrowseContext;
    public final Resource Views_Validations_BrowseContext_Checked;
    public final Resource Views_Validations_BrowseContext_Children;
    public final Resource Views_Validations_BrowseContext_Children_Rule;
    public final Resource Views_Validations_Cell1;
    public final Resource Views_Validations_Cell2;
    public final Resource Views_Validations_Columns;
    public final Resource Views_Validations_ConfigureButton;
    public final Resource Views_Validations_Explorer;
    public final Resource Views_Validations_Panel;
    public final Resource Views_Validations_Panel2;
    public final Resource Views_Validations_Root;
    public final Resource Views_Validations_ValidateButton;
    public final Resource Views_scl;
    public final Resource Views_sclEvent;
    public final Resource hasNameLabelMode;
    public final Resource hasNameLabelMode_Inverse;
        
    public static class URIs {
        public static final String Configuration = "http://www.simantics.org/PlatformUI-1.0/Configuration";
        public static final String Model = "http://www.simantics.org/PlatformUI-1.0/Model";
        public static final String NameLabelMode = "http://www.simantics.org/PlatformUI-1.0/NameLabelMode";
        public static final String NameLabelMode_Label = "http://www.simantics.org/PlatformUI-1.0/NameLabelMode/Label";
        public static final String NameLabelMode_LabelAndName = "http://www.simantics.org/PlatformUI-1.0/NameLabelMode/LabelAndName";
        public static final String NameLabelMode_Name = "http://www.simantics.org/PlatformUI-1.0/NameLabelMode/Name";
        public static final String NameLabelMode_NameAndLabel = "http://www.simantics.org/PlatformUI-1.0/NameLabelMode/NameAndLabel";
        public static final String SCLMain = "http://www.simantics.org/PlatformUI-1.0/SCLMain";
        public static final String SharedOntology = "http://www.simantics.org/PlatformUI-1.0/SharedOntology";
        public static final String StandardElementProperties = "http://www.simantics.org/PlatformUI-1.0/StandardElementProperties";
        public static final String StandardPropertiesTabContribution = "http://www.simantics.org/PlatformUI-1.0/StandardPropertiesTabContribution";
        public static final String Views = "http://www.simantics.org/PlatformUI-1.0/Views";
        public static final String Views_AvailableColumns = "http://www.simantics.org/PlatformUI-1.0/Views/AvailableColumns";
        public static final String Views_RangeSelectionTab = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTab";
        public static final String Views_RangeSelectionTabContribution = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTabContribution";
        public static final String Views_RangeSelectionTab_Cell1 = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTab/Cell1";
        public static final String Views_RangeSelectionTab_Cell2 = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTab/Cell2";
        public static final String Views_RangeSelectionTab_Combo = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTab/Combo";
        public static final String Views_RangeSelectionTab_Panel = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTab/Panel";
        public static final String Views_RangeSelectionTab_Root = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTab/Root";
        public static final String Views_RangeSelectionTab_Text = "http://www.simantics.org/PlatformUI-1.0/Views/RangeSelectionTab/Text";
        public static final String Views_SCLValue = "http://www.simantics.org/PlatformUI-1.0/Views/SCLValue";
        public static final String Views_SharedLibraries = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries";
        public static final String Views_SharedLibraries_AvailableContext = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/AvailableContext";
        public static final String Views_SharedLibraries_AvailableContext_Children = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/AvailableContext/Children";
        public static final String Views_SharedLibraries_AvailableContext_Children_Rule = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/AvailableContext/Children/Rule";
        public static final String Views_SharedLibraries_Cell1 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Cell1";
        public static final String Views_SharedLibraries_Cell2 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Cell2";
        public static final String Views_SharedLibraries_Cell3 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Cell3";
        public static final String Views_SharedLibraries_Cell4 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Cell4";
        public static final String Views_SharedLibraries_Cell5 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Cell5";
        public static final String Views_SharedLibraries_Cell6 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Cell6";
        public static final String Views_SharedLibraries_DefVar = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/DefVar";
        public static final String Views_SharedLibraries_DefVar2 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/DefVar2";
        public static final String Views_SharedLibraries_Explorer1 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Explorer1";
        public static final String Views_SharedLibraries_Explorer2 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Explorer2";
        public static final String Views_SharedLibraries_ImportButton = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/ImportButton";
        public static final String Views_SharedLibraries_LinkButton = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/LinkButton";
        public static final String Views_SharedLibraries_NewButton = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/NewButton";
        public static final String Views_SharedLibraries_Panel = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Panel";
        public static final String Views_SharedLibraries_Panel2 = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Panel2";
        public static final String Views_SharedLibraries_Root = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/Root";
        public static final String Views_SharedLibraries_UnlinkButton = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/UnlinkButton";
        public static final String Views_SharedLibraries_UnlinkEvent = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/UnlinkEvent";
        public static final String Views_SharedLibraries_UseEvent = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/UseEvent";
        public static final String Views_SharedLibraries_UsedContext = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/UsedContext";
        public static final String Views_SharedLibraries_UsedContext_Children = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/UsedContext/Children";
        public static final String Views_SharedLibraries_UsedContext_Children_Rule = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraries/UsedContext/Children/Rule";
        public static final String Views_SharedLibraryContribution = "http://www.simantics.org/PlatformUI-1.0/Views/SharedLibraryContribution";
        public static final String Views_UsedColumns = "http://www.simantics.org/PlatformUI-1.0/Views/UsedColumns";
        public static final String Views_ValidationContribution = "http://www.simantics.org/PlatformUI-1.0/Views/ValidationContribution";
        public static final String Views_Validations = "http://www.simantics.org/PlatformUI-1.0/Views/Validations";
        public static final String Views_Validations_BrowseContext = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/BrowseContext";
        public static final String Views_Validations_BrowseContext_Checked = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/BrowseContext/Checked";
        public static final String Views_Validations_BrowseContext_Children = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/BrowseContext/Children";
        public static final String Views_Validations_BrowseContext_Children_Rule = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/BrowseContext/Children/Rule";
        public static final String Views_Validations_Cell1 = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/Cell1";
        public static final String Views_Validations_Cell2 = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/Cell2";
        public static final String Views_Validations_Columns = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/Columns";
        public static final String Views_Validations_ConfigureButton = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/ConfigureButton";
        public static final String Views_Validations_Explorer = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/Explorer";
        public static final String Views_Validations_Panel = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/Panel";
        public static final String Views_Validations_Panel2 = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/Panel2";
        public static final String Views_Validations_Root = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/Root";
        public static final String Views_Validations_ValidateButton = "http://www.simantics.org/PlatformUI-1.0/Views/Validations/ValidateButton";
        public static final String Views_scl = "http://www.simantics.org/PlatformUI-1.0/Views/scl";
        public static final String Views_sclEvent = "http://www.simantics.org/PlatformUI-1.0/Views/sclEvent";
        public static final String hasNameLabelMode = "http://www.simantics.org/PlatformUI-1.0/hasNameLabelMode";
        public static final String hasNameLabelMode_Inverse = "http://www.simantics.org/PlatformUI-1.0/hasNameLabelMode/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public PlatformUIResource(ReadGraph graph) {
        Configuration = getResourceOrNull(graph, URIs.Configuration);
        Model = getResourceOrNull(graph, URIs.Model);
        NameLabelMode = getResourceOrNull(graph, URIs.NameLabelMode);
        NameLabelMode_Label = getResourceOrNull(graph, URIs.NameLabelMode_Label);
        NameLabelMode_LabelAndName = getResourceOrNull(graph, URIs.NameLabelMode_LabelAndName);
        NameLabelMode_Name = getResourceOrNull(graph, URIs.NameLabelMode_Name);
        NameLabelMode_NameAndLabel = getResourceOrNull(graph, URIs.NameLabelMode_NameAndLabel);
        SCLMain = getResourceOrNull(graph, URIs.SCLMain);
        SharedOntology = getResourceOrNull(graph, URIs.SharedOntology);
        StandardElementProperties = getResourceOrNull(graph, URIs.StandardElementProperties);
        StandardPropertiesTabContribution = getResourceOrNull(graph, URIs.StandardPropertiesTabContribution);
        Views = getResourceOrNull(graph, URIs.Views);
        Views_AvailableColumns = getResourceOrNull(graph, URIs.Views_AvailableColumns);
        Views_RangeSelectionTab = getResourceOrNull(graph, URIs.Views_RangeSelectionTab);
        Views_RangeSelectionTabContribution = getResourceOrNull(graph, URIs.Views_RangeSelectionTabContribution);
        Views_RangeSelectionTab_Cell1 = getResourceOrNull(graph, URIs.Views_RangeSelectionTab_Cell1);
        Views_RangeSelectionTab_Cell2 = getResourceOrNull(graph, URIs.Views_RangeSelectionTab_Cell2);
        Views_RangeSelectionTab_Combo = getResourceOrNull(graph, URIs.Views_RangeSelectionTab_Combo);
        Views_RangeSelectionTab_Panel = getResourceOrNull(graph, URIs.Views_RangeSelectionTab_Panel);
        Views_RangeSelectionTab_Root = getResourceOrNull(graph, URIs.Views_RangeSelectionTab_Root);
        Views_RangeSelectionTab_Text = getResourceOrNull(graph, URIs.Views_RangeSelectionTab_Text);
        Views_SCLValue = getResourceOrNull(graph, URIs.Views_SCLValue);
        Views_SharedLibraries = getResourceOrNull(graph, URIs.Views_SharedLibraries);
        Views_SharedLibraries_AvailableContext = getResourceOrNull(graph, URIs.Views_SharedLibraries_AvailableContext);
        Views_SharedLibraries_AvailableContext_Children = getResourceOrNull(graph, URIs.Views_SharedLibraries_AvailableContext_Children);
        Views_SharedLibraries_AvailableContext_Children_Rule = getResourceOrNull(graph, URIs.Views_SharedLibraries_AvailableContext_Children_Rule);
        Views_SharedLibraries_Cell1 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Cell1);
        Views_SharedLibraries_Cell2 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Cell2);
        Views_SharedLibraries_Cell3 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Cell3);
        Views_SharedLibraries_Cell4 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Cell4);
        Views_SharedLibraries_Cell5 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Cell5);
        Views_SharedLibraries_Cell6 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Cell6);
        Views_SharedLibraries_DefVar = getResourceOrNull(graph, URIs.Views_SharedLibraries_DefVar);
        Views_SharedLibraries_DefVar2 = getResourceOrNull(graph, URIs.Views_SharedLibraries_DefVar2);
        Views_SharedLibraries_Explorer1 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Explorer1);
        Views_SharedLibraries_Explorer2 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Explorer2);
        Views_SharedLibraries_ImportButton = getResourceOrNull(graph, URIs.Views_SharedLibraries_ImportButton);
        Views_SharedLibraries_LinkButton = getResourceOrNull(graph, URIs.Views_SharedLibraries_LinkButton);
        Views_SharedLibraries_NewButton = getResourceOrNull(graph, URIs.Views_SharedLibraries_NewButton);
        Views_SharedLibraries_Panel = getResourceOrNull(graph, URIs.Views_SharedLibraries_Panel);
        Views_SharedLibraries_Panel2 = getResourceOrNull(graph, URIs.Views_SharedLibraries_Panel2);
        Views_SharedLibraries_Root = getResourceOrNull(graph, URIs.Views_SharedLibraries_Root);
        Views_SharedLibraries_UnlinkButton = getResourceOrNull(graph, URIs.Views_SharedLibraries_UnlinkButton);
        Views_SharedLibraries_UnlinkEvent = getResourceOrNull(graph, URIs.Views_SharedLibraries_UnlinkEvent);
        Views_SharedLibraries_UseEvent = getResourceOrNull(graph, URIs.Views_SharedLibraries_UseEvent);
        Views_SharedLibraries_UsedContext = getResourceOrNull(graph, URIs.Views_SharedLibraries_UsedContext);
        Views_SharedLibraries_UsedContext_Children = getResourceOrNull(graph, URIs.Views_SharedLibraries_UsedContext_Children);
        Views_SharedLibraries_UsedContext_Children_Rule = getResourceOrNull(graph, URIs.Views_SharedLibraries_UsedContext_Children_Rule);
        Views_SharedLibraryContribution = getResourceOrNull(graph, URIs.Views_SharedLibraryContribution);
        Views_UsedColumns = getResourceOrNull(graph, URIs.Views_UsedColumns);
        Views_ValidationContribution = getResourceOrNull(graph, URIs.Views_ValidationContribution);
        Views_Validations = getResourceOrNull(graph, URIs.Views_Validations);
        Views_Validations_BrowseContext = getResourceOrNull(graph, URIs.Views_Validations_BrowseContext);
        Views_Validations_BrowseContext_Checked = getResourceOrNull(graph, URIs.Views_Validations_BrowseContext_Checked);
        Views_Validations_BrowseContext_Children = getResourceOrNull(graph, URIs.Views_Validations_BrowseContext_Children);
        Views_Validations_BrowseContext_Children_Rule = getResourceOrNull(graph, URIs.Views_Validations_BrowseContext_Children_Rule);
        Views_Validations_Cell1 = getResourceOrNull(graph, URIs.Views_Validations_Cell1);
        Views_Validations_Cell2 = getResourceOrNull(graph, URIs.Views_Validations_Cell2);
        Views_Validations_Columns = getResourceOrNull(graph, URIs.Views_Validations_Columns);
        Views_Validations_ConfigureButton = getResourceOrNull(graph, URIs.Views_Validations_ConfigureButton);
        Views_Validations_Explorer = getResourceOrNull(graph, URIs.Views_Validations_Explorer);
        Views_Validations_Panel = getResourceOrNull(graph, URIs.Views_Validations_Panel);
        Views_Validations_Panel2 = getResourceOrNull(graph, URIs.Views_Validations_Panel2);
        Views_Validations_Root = getResourceOrNull(graph, URIs.Views_Validations_Root);
        Views_Validations_ValidateButton = getResourceOrNull(graph, URIs.Views_Validations_ValidateButton);
        Views_scl = getResourceOrNull(graph, URIs.Views_scl);
        Views_sclEvent = getResourceOrNull(graph, URIs.Views_sclEvent);
        hasNameLabelMode = getResourceOrNull(graph, URIs.hasNameLabelMode);
        hasNameLabelMode_Inverse = getResourceOrNull(graph, URIs.hasNameLabelMode_Inverse);
    }
    
    public static PlatformUIResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        PlatformUIResource ret = session.peekService(PlatformUIResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new PlatformUIResource(qc.getIndependentGraph(graph));
            session.registerService(PlatformUIResource.class, ret);
        }
        return ret;
    }
    
    public static PlatformUIResource getInstance(RequestProcessor session) throws DatabaseException {
        PlatformUIResource ret = session.peekService(PlatformUIResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<PlatformUIResource>() {
                public PlatformUIResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new PlatformUIResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(PlatformUIResource.class, ret);
        }
        return ret;
    }
    
}

