/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleActiveVariableFromVariable extends UnaryRead<Variable, Variable> {

    public PossibleActiveVariableFromVariable(Variable configurationVariable) {
        super(configurationVariable);
    }

    @Override
    public Variable perform(ReadGraph graph) throws DatabaseException {

    	Layer0 b = Layer0.getInstance(graph);
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        Resource result = null;
        
        Resource model = Variables.getPossibleModel(graph, parameter);
        if (model == null)
            return null;

        for(Resource config : graph.getObjects(model, b.ConsistsOf)) {
            if(graph.isInstanceOf(config, SIMU.Experiment)) {
                for(Resource run : graph.getObjects(config, b.ConsistsOf)) {
                    if(graph.isInstanceOf(run, SIMU.Run)) {
                        if(graph.hasStatement(run, SIMU.IsActive)) {
                            if(result != null) return null;
                            result = run;
                        }
                    }
                }
            }
        }
        
        if(result == null) return null;

        return Variables.switchPossibleContext(graph, parameter, result);

    }

}
