/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class LinkedIndexRoots extends ResourceRead<Set<Resource>> {

    public LinkedIndexRoots(Resource indexRoot) {
        super(indexRoot);
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {

    	Layer0 L0 = Layer0.getInstance(graph);

    	HashSet<Resource> result = new HashSet<Resource>();
    	result.add(resource);
    	for(Resource link : graph.sync(new ObjectsWithType(resource, L0.IsLinkedTo, L0.IndexRoot))) {
    		result.addAll(graph.sync(new LinkedIndexRoots(link)));
    	}
    	return result;

    }

}
