/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.migration;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.db.ImportResult;

/**
 * @author Tuukka Lehtonen
 * @since 1.28.0
 */
public class MigratedImportResult {

	/**
	 * The root resources created by the import process.
	 */
	public final Collection<Resource> roots;

	public final ImportResult tgResult;

	public MigratedImportResult(Collection<Resource> roots, ImportResult tgResult) {
		this.roots = roots;
		this.tgResult = tgResult;
	}

	public Resource singleRoot() throws DatabaseException {
		int s = roots.size();
		if (s != 1)
			throw new AssumptionException("No single imported root found, roots are: " + roots);
		return roots.iterator().next();
	}

	public boolean hasMissingExternals() {
		return tgResult != null ? tgResult.hasMissingExternals() : false;
	}

}
