/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.simulation.ontology.SimulationResource;

@Deprecated
public class ModelPasteHandler implements PasteHandler {

	private Resource resource;
	
	public ModelPasteHandler(Resource resource) {
		this.resource = resource;
	}
	
	@Override
	public Collection<Resource> pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
		throw new UnsupportedOperationException();
	}

	@Override
	public Collection<Resource> pasteFromClipboard(SimanticsClipboard clipboard) throws DatabaseException {

		final Collection<Resource> result = new ArrayList<Resource>();
		final Set<Resource> cuts = new HashSet<Resource>();
		for(Set<Representation> object : clipboard.getContents()) {
			
			TransferableGraph1 tg = ClipboardUtils.accept(object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
			if(tg != null) {

				try {
					
					DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(resource) {
						
						public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {

							SimulationResource SIMU = SimulationResource.getInstance(graph);
							Resource typeResource = graph.getResource(root.type);
							if(graph.isInheritedFrom(typeResource, SIMU.Model)) {
								library = SimanticsInternal.getProject();
							}
							
						}

					};
					
					TransferableGraphs.importGraph1(SimanticsInternal.getSession(), tg, advisor);
					result.addAll(advisor.getRoots());
					
				} catch (TransferableGraphException e) {
					throw new DatabaseException(e);
				}
				
			}
			
			final Collection<Resource> cut = ClipboardUtils.accept(object, SimanticsKeys.KEY_CUT_RESOURCES);
			if(cut != null) cuts.addAll(cut);
			
		}
		
		if(!cuts.isEmpty()) {
			SimanticsInternal.getSession().syncRequest(new WriteRequest() {

				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					for(Resource cut : cuts) graph.deny(cut);
				}
				
			});
		}
		
		return result;

	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getAdapter(Class<T> adapter) {
		if(Resource.class == adapter) return (T) resource;
		return null;
	}
	
}
