/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.request;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class GetName extends ResourceRead<String> {

    public GetName(Resource resource) {
        super(resource);
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        try {
            return graph.getRelatedValue(resource, Layer0.getInstance(graph).HasName, Bindings.STRING);
        } catch (DatabaseException e) {
            return NameUtils.getSafeName(graph, resource);
        }
    }

}
