/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.imager;

import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ImagerKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.graph.impl.contribution.ImagerContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.datastructures.ArrayMap;

abstract public class ImagerContributorImpl<T> implements Contributor<ImagerFactory> {

    abstract public ImageDescriptor getDescriptor(ReadGraph graph, T input) throws DatabaseException;

    final private Class<?> clazz;

    @Override
    public String toString() {
        return getClass().getName();
    }

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public ImagerContributorImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public ImagerContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ImagerFactory getFactory() {

        return new ImagerFactory() {

            @Override
            public String toString() {
                return ImagerContributorImpl.this.toString();
            }

            @SuppressWarnings("unchecked")
            @Override
            public Imager create(final PrimitiveQueryUpdater updater, NodeContext context, final ImagerKey key) {

                return new ImagerContributionImpl(updater, context, key) {

                    @Override
                    public Map<String, ImageDescriptor> getDescriptors(ReadGraph graph, NodeContext context) throws DatabaseException {

                        T input = (T)context.getConstant(BuiltinKeys.INPUT);

                        ImageDescriptor value = ImagerContributorImpl.this.getDescriptor(graph, input);

                        return new ArrayMap<String, ImageDescriptor>(ColumnKeys.KEYS_SINGLE,
                                new ImageDescriptor[] { value });

                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
