/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ui.ErrorLogger;

/**
 * Please implement:
 * <ul>
 * <li>{@link #createModifierInput(String)} - constructs an input for
 * {@link org.simantics.db.layer0.adapter.Modifier#modify(WriteGraph, Object)}
 * from the specified label given by the user.
 * <li>{@link #doModify(WriteGraph, String)} - perform the requested
 * modification into the graph.</li>
 * </ul>
 * 
 * <p>
 * See {@link AbstractStringModifier} for more information.
 * </p>
 * 
 * @author Tuukka Lehtonen
 * 
 * @param <T> the input class of the used
 *        {@link org.simantics.db.layer0.adapter.Modifier}
 */
public class GraphFactoryStringModifier extends AbstractFactoryStringModifier {

    /**
     * @param context
     * @param session
     */
    public GraphFactoryStringModifier(Resource subject, Resource predicate, Resource object, RequestProcessor processor) {
        super(subject, predicate, object, processor);
    }

    @Override
    public final void doModify(final String label) {
        session.asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                doModifyWithFactory(graph, label);
            }
        }, parameter -> {
            if (parameter != null)
                ErrorLogger.defaultLogError(parameter);
        });
    }

    public void doModifyWithFactory(WriteGraph graph, String label) throws DatabaseException {
        if (getModifierFactory() != null)
            getModifier().modify(graph, label);
        else
            doModify(graph, label);
    }

    public void doModify(WriteGraph graph, String label) throws DatabaseException {
        getModifier().modify(graph, label);
    }

};
