package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.GraphHints;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;

public class EvaluatorViewpoint extends LazyViewpoint {

    final BrowseContext browseContext;
    final boolean useNodeBrowseContexts;
    final boolean useNodeActionContexts;

    public EvaluatorViewpoint(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key,
            BrowseContext browseContext, boolean useNodeBrowseContexts, boolean useNodeActionContexts) {
        super(updater, context, key);
        this.browseContext = browseContext;
        this.useNodeActionContexts = useNodeActionContexts;
        this.useNodeBrowseContexts = useNodeBrowseContexts;
    }

    @Override
    public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
        return BrowseContext.get(graph,context,browseContext,useNodeBrowseContexts).hasChildren(graph, context);
    }

    @Override
    public NodeContext[] children(ReadGraph graph) throws DatabaseException {
        GraphHints old = graph.setHintValue(ReadGraph.GRAPH_HINT_SYNCHRONOUS, false); 
        try {
            // This intermediate query is a work-around for a listening
            // bug where old dependencies are not correctly pruned for listened entries
            return graph.syncRequest(new UniqueRead<NodeContext[]>() {

                @Override
                public NodeContext[] perform(ReadGraph graph) throws DatabaseException {
                    BrowseContext bc = BrowseContext.get(graph,context,browseContext,useNodeBrowseContexts);
                    Collection<NodeContext> children = bc.getChildren(graph, context);
                    children = BrowseContext.augment(graph, bc, children, useNodeActionContexts);
                    return children.toArray(new NodeContext[children.size()]);
                }

            });
        } finally {
            graph.setHints(old);
        }
    }

    public String toString() {
        return "EvaluatorViewpoint[" + browseContext + "] " + context;
    }

}