/* This file was generated by SableCC (http://www.sablecc.org/). */

package org.simantics.basicexpression.parser;

import org.simantics.basicexpression.lexer.*;
import org.simantics.basicexpression.node.*;
import org.simantics.basicexpression.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings("nls")
public class Parser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;

    public Parser(@SuppressWarnings("hiding") Lexer lexer)
    {
        this.lexer = lexer;
    }

    protected void filter() throws ParserException, LexerException, IOException
    {
        // Empty body
    }

    private void push(int numstate, ArrayList listNode, boolean hidden) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!hidden)
        {
            filter();
        }

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
        return ((State) this.stack.previous()).nodes;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

    @SuppressWarnings("unchecked")
    public Start parse() throws ParserException, LexerException, IOException
    {
        push(0, null, true);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list, false);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce AMultExpression */
		    {
			ArrayList list = new0();
			push(goTo(0), list, false);
		    }
		    break;
                    case 1: /* reduce APlusExpression */
		    {
			ArrayList list = new1();
			push(goTo(0), list, false);
		    }
		    break;
                    case 2: /* reduce AMinusExpression */
		    {
			ArrayList list = new2();
			push(goTo(0), list, false);
		    }
		    break;
                    case 3: /* reduce AUnaryMultiplicative */
		    {
			ArrayList list = new3();
			push(goTo(1), list, false);
		    }
		    break;
                    case 4: /* reduce AMultMultiplicative */
		    {
			ArrayList list = new4();
			push(goTo(1), list, false);
		    }
		    break;
                    case 5: /* reduce ADivMultiplicative */
		    {
			ArrayList list = new5();
			push(goTo(1), list, false);
		    }
		    break;
                    case 6: /* reduce APrimaryUnary */
		    {
			ArrayList list = new6();
			push(goTo(2), list, false);
		    }
		    break;
                    case 7: /* reduce AUnaryplusUnary */
		    {
			ArrayList list = new7();
			push(goTo(2), list, false);
		    }
		    break;
                    case 8: /* reduce AUnaryminusUnary */
		    {
			ArrayList list = new8();
			push(goTo(2), list, false);
		    }
		    break;
                    case 9: /* reduce ASingleArgList */
		    {
			ArrayList list = new9();
			push(goTo(3), list, false);
		    }
		    break;
                    case 10: /* reduce ASequenceArgList */
		    {
			ArrayList list = new10();
			push(goTo(3), list, false);
		    }
		    break;
                    case 11: /* reduce AValuePrimary */
		    {
			ArrayList list = new11();
			push(goTo(4), list, false);
		    }
		    break;
                    case 12: /* reduce AVariablePrimary */
		    {
			ArrayList list = new12();
			push(goTo(4), list, false);
		    }
		    break;
                    case 13: /* reduce AAfunctionprimary1Primary */
		    {
			ArrayList list = new13();
			push(goTo(4), list, false);
		    }
		    break;
                    case 14: /* reduce AAfunctionprimary2Primary */
		    {
			ArrayList list = new14();
			push(goTo(4), list, false);
		    }
		    break;
                    case 15: /* reduce ASingleRange */
		    {
			ArrayList list = new15();
			push(goTo(5), list, false);
		    }
		    break;
                    case 16: /* reduce AMultiRange */
		    {
			ArrayList list = new16();
			push(goTo(5), list, false);
		    }
		    break;
                    case 17: /* reduce ARviValue */
		    {
			ArrayList list = new17();
			push(goTo(6), list, false);
		    }
		    break;
                    case 18: /* reduce AStringValue */
		    {
			ArrayList list = new18();
			push(goTo(6), list, false);
		    }
		    break;
                    case 19: /* reduce AConstantValue */
		    {
			ArrayList list = new19();
			push(goTo(6), list, false);
		    }
		    break;
                    case 20: /* reduce ARangeValue */
		    {
			ArrayList list = new20();
			push(goTo(6), list, false);
		    }
		    break;
                    case 21: /* reduce AAddressValue */
		    {
			ArrayList list = new21();
			push(goTo(6), list, false);
		    }
		    break;
                    case 22: /* reduce AExprValue */
		    {
			ArrayList list = new22();
			push(goTo(6), list, false);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PExpression node1 = (PExpression) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " +
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



    @SuppressWarnings("unchecked")
    ArrayList new0() /* reduce AMultExpression */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PExpression pexpressionNode1;
        {
            // Block
        PMultiplicative pmultiplicativeNode2;
        pmultiplicativeNode2 = (PMultiplicative)nodeArrayList1.get(0);

        pexpressionNode1 = new AMultExpression(pmultiplicativeNode2);
        }
	nodeList.add(pexpressionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new1() /* reduce APlusExpression */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PExpression pexpressionNode1;
        {
            // Block
        PExpression pexpressionNode2;
        TPlus tplusNode3;
        PMultiplicative pmultiplicativeNode4;
        pexpressionNode2 = (PExpression)nodeArrayList1.get(0);
        tplusNode3 = (TPlus)nodeArrayList2.get(0);
        pmultiplicativeNode4 = (PMultiplicative)nodeArrayList3.get(0);

        pexpressionNode1 = new APlusExpression(pexpressionNode2, tplusNode3, pmultiplicativeNode4);
        }
	nodeList.add(pexpressionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new2() /* reduce AMinusExpression */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PExpression pexpressionNode1;
        {
            // Block
        PExpression pexpressionNode2;
        TMinus tminusNode3;
        PMultiplicative pmultiplicativeNode4;
        pexpressionNode2 = (PExpression)nodeArrayList1.get(0);
        tminusNode3 = (TMinus)nodeArrayList2.get(0);
        pmultiplicativeNode4 = (PMultiplicative)nodeArrayList3.get(0);

        pexpressionNode1 = new AMinusExpression(pexpressionNode2, tminusNode3, pmultiplicativeNode4);
        }
	nodeList.add(pexpressionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new3() /* reduce AUnaryMultiplicative */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PMultiplicative pmultiplicativeNode1;
        {
            // Block
        PUnary punaryNode2;
        punaryNode2 = (PUnary)nodeArrayList1.get(0);

        pmultiplicativeNode1 = new AUnaryMultiplicative(punaryNode2);
        }
	nodeList.add(pmultiplicativeNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new4() /* reduce AMultMultiplicative */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PMultiplicative pmultiplicativeNode1;
        {
            // Block
        PMultiplicative pmultiplicativeNode2;
        TMult tmultNode3;
        PUnary punaryNode4;
        pmultiplicativeNode2 = (PMultiplicative)nodeArrayList1.get(0);
        tmultNode3 = (TMult)nodeArrayList2.get(0);
        punaryNode4 = (PUnary)nodeArrayList3.get(0);

        pmultiplicativeNode1 = new AMultMultiplicative(pmultiplicativeNode2, tmultNode3, punaryNode4);
        }
	nodeList.add(pmultiplicativeNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new5() /* reduce ADivMultiplicative */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PMultiplicative pmultiplicativeNode1;
        {
            // Block
        PMultiplicative pmultiplicativeNode2;
        TDiv tdivNode3;
        PUnary punaryNode4;
        pmultiplicativeNode2 = (PMultiplicative)nodeArrayList1.get(0);
        tdivNode3 = (TDiv)nodeArrayList2.get(0);
        punaryNode4 = (PUnary)nodeArrayList3.get(0);

        pmultiplicativeNode1 = new ADivMultiplicative(pmultiplicativeNode2, tdivNode3, punaryNode4);
        }
	nodeList.add(pmultiplicativeNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new6() /* reduce APrimaryUnary */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PUnary punaryNode1;
        {
            // Block
        PPrimary pprimaryNode2;
        pprimaryNode2 = (PPrimary)nodeArrayList1.get(0);

        punaryNode1 = new APrimaryUnary(pprimaryNode2);
        }
	nodeList.add(punaryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new7() /* reduce AUnaryplusUnary */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PUnary punaryNode1;
        {
            // Block
        TPlus tplusNode2;
        PUnary punaryNode3;
        tplusNode2 = (TPlus)nodeArrayList1.get(0);
        punaryNode3 = (PUnary)nodeArrayList2.get(0);

        punaryNode1 = new AUnaryplusUnary(tplusNode2, punaryNode3);
        }
	nodeList.add(punaryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new8() /* reduce AUnaryminusUnary */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PUnary punaryNode1;
        {
            // Block
        TMinus tminusNode2;
        PUnary punaryNode3;
        tminusNode2 = (TMinus)nodeArrayList1.get(0);
        punaryNode3 = (PUnary)nodeArrayList2.get(0);

        punaryNode1 = new AUnaryminusUnary(tminusNode2, punaryNode3);
        }
	nodeList.add(punaryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new9() /* reduce ASingleArgList */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PArgList parglistNode1;
        {
            // Block
        PExpression pexpressionNode2;
        pexpressionNode2 = (PExpression)nodeArrayList1.get(0);

        parglistNode1 = new ASingleArgList(pexpressionNode2);
        }
	nodeList.add(parglistNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new10() /* reduce ASequenceArgList */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PArgList parglistNode1;
        {
            // Block
        PArgList parglistNode2;
        TComma tcommaNode3;
        PExpression pexpressionNode4;
        parglistNode2 = (PArgList)nodeArrayList1.get(0);
        tcommaNode3 = (TComma)nodeArrayList2.get(0);
        pexpressionNode4 = (PExpression)nodeArrayList3.get(0);

        parglistNode1 = new ASequenceArgList(parglistNode2, tcommaNode3, pexpressionNode4);
        }
	nodeList.add(parglistNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new11() /* reduce AValuePrimary */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PPrimary pprimaryNode1;
        {
            // Block
        PValue pvalueNode2;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);

        pprimaryNode1 = new AValuePrimary(pvalueNode2);
        }
	nodeList.add(pprimaryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new12() /* reduce AVariablePrimary */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PPrimary pprimaryNode1;
        {
            // Block
        TVariable tvariableNode2;
        tvariableNode2 = (TVariable)nodeArrayList1.get(0);

        pprimaryNode1 = new AVariablePrimary(tvariableNode2);
        }
	nodeList.add(pprimaryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new13() /* reduce AAfunctionprimary1Primary */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PPrimary pprimaryNode1;
        {
            // Block
        TFunc tfuncNode2;
        @SuppressWarnings("unused") Object nullNode3 = null;
        TRPar trparNode4;
        tfuncNode2 = (TFunc)nodeArrayList1.get(0);
        trparNode4 = (TRPar)nodeArrayList2.get(0);

        pprimaryNode1 = new AFunctionPrimary(tfuncNode2, null, trparNode4);
        }
	nodeList.add(pprimaryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new14() /* reduce AAfunctionprimary2Primary */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PPrimary pprimaryNode1;
        {
            // Block
        TFunc tfuncNode2;
        PArgList parglistNode3;
        TRPar trparNode4;
        tfuncNode2 = (TFunc)nodeArrayList1.get(0);
        parglistNode3 = (PArgList)nodeArrayList2.get(0);
        trparNode4 = (TRPar)nodeArrayList3.get(0);

        pprimaryNode1 = new AFunctionPrimary(tfuncNode2, parglistNode3, trparNode4);
        }
	nodeList.add(pprimaryNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new15() /* reduce ASingleRange */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PRange prangeNode1;
        {
            // Block
        TCell tcellNode2;
        tcellNode2 = (TCell)nodeArrayList1.get(0);

        prangeNode1 = new ASingleRange(tcellNode2);
        }
	nodeList.add(prangeNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new16() /* reduce AMultiRange */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PRange prangeNode1;
        {
            // Block
        TCell tcellNode2;
        TColon tcolonNode3;
        TCell tcellNode4;
        tcellNode2 = (TCell)nodeArrayList1.get(0);
        tcolonNode3 = (TColon)nodeArrayList2.get(0);
        tcellNode4 = (TCell)nodeArrayList3.get(0);

        prangeNode1 = new AMultiRange(tcellNode2, tcolonNode3, tcellNode4);
        }
	nodeList.add(prangeNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new17() /* reduce ARviValue */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TRvi trviNode2;
        trviNode2 = (TRvi)nodeArrayList1.get(0);

        pvalueNode1 = new ARviValue(trviNode2);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new18() /* reduce AStringValue */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TString tstringNode2;
        tstringNode2 = (TString)nodeArrayList1.get(0);

        pvalueNode1 = new AStringValue(tstringNode2);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new19() /* reduce AConstantValue */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TNumber tnumberNode2;
        tnumberNode2 = (TNumber)nodeArrayList1.get(0);

        pvalueNode1 = new AConstantValue(tnumberNode2);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new20() /* reduce ARangeValue */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        PRange prangeNode2;
        prangeNode2 = (PRange)nodeArrayList1.get(0);

        pvalueNode1 = new ARangeValue(prangeNode2);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new21() /* reduce AAddressValue */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TAmpersand tampersandNode2;
        PRange prangeNode3;
        tampersandNode2 = (TAmpersand)nodeArrayList1.get(0);
        prangeNode3 = (PRange)nodeArrayList2.get(0);

        pvalueNode1 = new AAddressValue(tampersandNode2, prangeNode3);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new22() /* reduce AExprValue */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TLPar tlparNode2;
        PExpression pexpressionNode3;
        TRPar trparNode4;
        tlparNode2 = (TLPar)nodeArrayList1.get(0);
        pexpressionNode3 = (PExpression)nodeArrayList2.get(0);
        trparNode4 = (TRPar)nodeArrayList3.get(0);

        pvalueNode1 = new AExprValue(tlparNode2, pexpressionNode3, trparNode4);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, ERROR, 1}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, ERROR, 2}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, ERROR, 3}, {14, SHIFT, 7}, },
			{{-1, ERROR, 4}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, REDUCE, 12}, },
			{{-1, ERROR, 6}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {11, SHIFT, 21}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, REDUCE, 15}, {9, SHIFT, 24}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 19}, },
			{{-1, REDUCE, 18}, },
			{{-1, ERROR, 11}, {3, SHIFT, 25}, {4, SHIFT, 26}, {19, ACCEPT, -1}, },
			{{-1, REDUCE, 0}, {5, SHIFT, 27}, {6, SHIFT, 28}, },
			{{-1, REDUCE, 3}, },
			{{-1, REDUCE, 6}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 7}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 21}, },
			{{-1, ERROR, 20}, {3, SHIFT, 25}, {4, SHIFT, 26}, {11, SHIFT, 29}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 9}, {3, SHIFT, 25}, {4, SHIFT, 26}, },
			{{-1, ERROR, 23}, {8, SHIFT, 30}, {11, SHIFT, 31}, },
			{{-1, ERROR, 24}, {14, SHIFT, 32}, },
			{{-1, ERROR, 25}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, ERROR, 26}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, ERROR, 27}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, ERROR, 28}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, REDUCE, 22}, },
			{{-1, ERROR, 30}, {3, SHIFT, 1}, {4, SHIFT, 2}, {7, SHIFT, 3}, {10, SHIFT, 4}, {12, SHIFT, 5}, {13, SHIFT, 6}, {14, SHIFT, 7}, {15, SHIFT, 8}, {16, SHIFT, 9}, {17, SHIFT, 10}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 16}, },
			{{-1, REDUCE, 1}, {5, SHIFT, 27}, {6, SHIFT, 28}, },
			{{-1, REDUCE, 2}, {5, SHIFT, 27}, {6, SHIFT, 28}, },
			{{-1, REDUCE, 4}, },
			{{-1, REDUCE, 5}, },
			{{-1, REDUCE, 10}, {3, SHIFT, 25}, {4, SHIFT, 26}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 11}, {4, 20}, {6, 22}, {30, 37}, },
			{{-1, 12}, {25, 33}, {26, 34}, },
			{{-1, 13}, {1, 17}, {2, 18}, {27, 35}, {28, 36}, },
			{{-1, 23}, },
			{{-1, 14}, },
			{{-1, 15}, {3, 19}, },
			{{-1, 16}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: '+', '-', '&', '(', variable, func, cell, rvi, number, string",
			"expecting: cell",
			"expecting: '+', '-', '*', '/', ',', ')', EOF",
			"expecting: '+', '-', '&', '(', ')', variable, func, cell, rvi, number, string",
			"expecting: '+', '-', '*', '/', ',', ':', ')', EOF",
			"expecting: '+', '-', EOF",
			"expecting: '+', '-', ')'",
			"expecting: '+', '-', ',', ')'",
			"expecting: ',', ')'",
        };*/
    private static int[] errors;
/*      {
			0, 0, 0, 1, 0, 2, 3, 4, 2, 2, 2, 5, 2, 2, 2, 2, 2, 2, 2, 2, 6, 2, 7, 8, 1, 0, 0, 0, 0, 2, 0, 2, 2, 2, 2, 2, 2, 7, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
