/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalByteCharMapOps;
import com.koloboke.collect.map.ByteCharMap;
import com.koloboke.function.ByteCharConsumer;
import com.koloboke.function.ByteCharPredicate;
import java.util.Map;

public final class CommonByteCharMapOps {
    public static boolean containsAllEntries(final InternalByteCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteCharMap) {
            ByteCharMap m2 = (ByteCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteCharMapOps) {
                return ((InternalByteCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteCharPredicate(){

                public boolean test(byte a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Byte)e.getKey(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteCharMapOps map, Map<? extends Byte, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteCharMap) {
            if (another instanceof InternalByteCharMapOps) {
                ((InternalByteCharMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteCharMap)another).forEach(new ByteCharConsumer(){

                    public void accept(byte key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().charValue());
            }
        }
    }

    private CommonByteCharMapOps() {
    }
}

