/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.matching;

import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import org.simantics.graph.matching.CanonicalGraph;
import org.simantics.graph.matching.CanonicalizingMatchingStrategy;
import org.simantics.graph.matching.GraphMatchingStrategy;
import org.simantics.graph.matching.IdentityMatchingStrategy;
import org.simantics.graph.matching.Stat;
import org.simantics.graph.matching.VotingMatchingStrategy;
import org.simantics.graph.representation.TransferableGraph1;

public class GraphMatching {
    public static final boolean DEBUG = false;
    public static final boolean TIMING = false;
    int aOriginalSize;
    int bOriginalSize;
    CanonicalGraph aGraph;
    CanonicalGraph bGraph;
    protected int[] aToB;
    protected int[] bToA;
    int size;

    public GraphMatching(TransferableGraph1 a, TransferableGraph1 b) {
        long begin = System.nanoTime();
        this.aGraph = new CanonicalGraph(a);
        this.bGraph = new CanonicalGraph(b);
        this.aToB = new int[this.aGraph.resourceCount];
        Arrays.fill(this.aToB, -1);
        this.bToA = new int[this.bGraph.resourceCount];
        Arrays.fill(this.bToA, -1);
        this.aOriginalSize = a.resourceCount;
        this.bOriginalSize = b.resourceCount;
    }

    public void print() {
        System.out.println("Resources in a:  " + this.aGraph.resourceCount);
        System.out.println("Identities in a: " + this.aGraph.identities.length);
        System.out.println("Statements in a: " + this.aGraph.statements.length / 6);
        System.out.println();
        System.out.println("Resources in b:  " + this.bGraph.resourceCount);
        System.out.println("Identities in b: " + this.bGraph.identities.length);
        System.out.println("Statements in b: " + this.bGraph.statements.length / 6);
        System.out.println();
        System.out.println("Match size:      " + this.size());
    }

    public int size() {
        return this.size;
    }

    public void recomputeSize() {
        int count = 0;
        int[] nArray = this.aToB;
        int n = this.aToB.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            if (b >= 0) {
                ++count;
            }
            ++n2;
        }
        this.size = count;
    }

    public void map(int a, int b) {
        ++this.size;
        this.aToB[a] = b;
        this.bToA[b] = a;
    }

    public void map(int[] as, int[] bs) {
        int i = 0;
        while (i < as.length) {
            this.map(as[i], bs[i]);
            ++i;
        }
    }

    public void unmap(int a, int b) {
        --this.size;
        this.aToB[a] = -1;
        this.bToA[b] = -1;
    }

    public void unmap(int[] as, int[] bs) {
        int i = 0;
        while (i < as.length) {
            this.unmap(as[i], bs[i]);
            ++i;
        }
    }

    public boolean checkMatch(int[] as, int[] bs) {
        int i = 0;
        while (i < as.length) {
            if (!this.checkMatch(as[i], bs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkMatch(int a, int b) {
        Stat stat;
        Stat[] aStats = this.aGraph.statements[a];
        Stat[] bStats = this.bGraph.statements[b];
        if (aStats.length != bStats.length) {
            return false;
        }
        THashSet<Stat> mappedStats = new THashSet<Stat>();
        int[] aToB = this.aToB;
        Stat[] statArray = aStats;
        int n = aStats.length;
        int n2 = 0;
        while (n2 < n) {
            stat = statArray[n2];
            int mp = aToB[stat.p];
            int mo = aToB[stat.o];
            if (mp < 0 || mo < 0) {
                return false;
            }
            mappedStats.add(new Stat(mp, mo));
            ++n2;
        }
        statArray = bStats;
        n = bStats.length;
        n2 = 0;
        while (n2 < n) {
            stat = statArray[n2];
            if (!mappedStats.contains(stat)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int maxSize() {
        return Math.min(this.aGraph.resourceCount, this.bGraph.resourceCount);
    }

    public int[] getAToB() {
        return this.aToB;
    }

    public int[] getBToA() {
        return this.bToA;
    }

    public static int[] cut(int[] map, int domainSize, int rangeSize) {
        int[] newMap = new int[domainSize];
        int i = 0;
        while (i < domainSize) {
            int temp = map[i];
            newMap[i] = temp >= rangeSize ? -1 : temp;
            ++i;
        }
        return newMap;
    }

    public void match() {
        this.apply(IdentityMatchingStrategy.INSTANCE);
        this.apply(CanonicalizingMatchingStrategy.INSTANCE);
        while (this.size != this.maxSize()) {
            int curSize = this.size;
            this.apply(VotingMatchingStrategy.INSTANCE);
            if (this.size != curSize) continue;
        }
        this.aToB = GraphMatching.cut(this.aToB, this.aOriginalSize, this.bOriginalSize);
        this.bToA = GraphMatching.cut(this.bToA, this.bOriginalSize, this.aOriginalSize);
    }

    private void apply(GraphMatchingStrategy strategy) {
        strategy.applyTo(this);
    }
}

