/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.units;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.databoard.units.IdentityConverter;
import org.simantics.databoard.units.LinearConverter;
import org.simantics.databoard.units.internal.library.UnitConversion;
import org.simantics.databoard.units.internal.library.UnitLibrary;
import org.simantics.databoard.units.internal.parser.UnitParser;

public class ConverterCreator
extends UnitParser
implements TObjectIntProcedure<String> {
    UnitLibrary library;
    TObjectIntHashMap<String> exponents = new TObjectIntHashMap();
    double scale = 1.0;
    int magnitude = 0;

    public ConverterCreator(UnitLibrary library) {
        this.library = library;
    }

    @Override
    public void visit(String baseUnit, int exponent) {
        if (this.exponents.adjustOrPutValue(baseUnit, exponent, exponent) == 0) {
            this.exponents.remove(baseUnit);
        }
    }

    public IUnitConverter createConverter() {
        if (this.exponents.isEmpty()) {
            return IdentityConverter.INSTANCE;
        }
        TObjectIntHashMap<String> oldExponents = this.exponents;
        this.exponents = new TObjectIntHashMap();
        oldExponents.forEachEntry(this);
        if (this.exponents.isEmpty()) {
            if (this.magnitude == 0 && this.scale == 1.0) {
                return IdentityConverter.INSTANCE;
            }
            return new LinearConverter(this.scale * Math.pow(10.0, this.magnitude));
        }
        return null;
    }

    @Override
    public boolean execute(String unit, int exponent) {
        UnitConversion conversion = this.library.getConversion(unit);
        if (conversion == null) {
            if (this.exponents.adjustOrPutValue(unit, exponent, exponent) == 0) {
                this.exponents.remove(unit);
            }
        } else {
            if (conversion.scale != 1.0) {
                this.scale *= Math.pow(conversion.scale, exponent);
            }
            this.magnitude += conversion.magnitude * exponent;
            int i = 0;
            while (i < conversion.baseUnits.length) {
                String u = conversion.baseUnits[i];
                int exp = conversion.exponents[i] * exponent;
                if (this.exponents.adjustOrPutValue(u, exp, exp) == 0) {
                    this.exponents.remove(u);
                }
                ++i;
            }
        }
        return true;
    }
}

