/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class IntegerType
extends NumberType {
    public IntegerType() {
    }

    public IntegerType(String unit) {
        this.setUnit(unit);
    }

    public IntegerType(String unit, String range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public IntegerType(String unit, Range range) {
        this.setUnit(unit);
        this.setRange(range);
    }

    public int minValue() {
        Range range = this.getRange();
        if (range == null) {
            return Integer.MIN_VALUE;
        }
        Limit l = range.getLower();
        int value = l.getValue().intValue();
        if (l.isExclusive()) {
            ++value;
        }
        return value;
    }

    public int maxValue() {
        Range range = this.getRange();
        if (range == null) {
            return Integer.MAX_VALUE;
        }
        Limit l = range.getUpper();
        int value = l.getValue().intValue();
        if (l.isExclusive()) {
            --value;
        }
        return value;
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        return obj instanceof IntegerType;
    }

    @Override
    public int hashCode() {
        return 180155731 + this.metadataHashCode();
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }
}

