/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.simantics.databoard.util.binary.BinaryFile;

public class testFileUtil
extends TestCase {
    public void testInsertRemove() throws IOException {
        File tmp1 = File.createTempFile("tmp", "tmp");
        tmp1.deleteOnExit();
        RandomAccessFile file = new RandomAccessFile(tmp1, "rw");
        BinaryFile write = new BinaryFile(file);
        int i = 0;
        while (i < 0x100000) {
            write.writeInt(i ^ 0x53);
            ++i;
        }
        write.flush();
        write.close();
        int iterCount = 16;
        long totInsertTime = 0L;
        long totRemoveTime = 0L;
        int iter = 0;
        while (iter < iterCount) {
            file = new RandomAccessFile(tmp1, "rw");
            BinaryFile read = new BinaryFile(file);
            read.position(0L);
            int i2 = 0;
            while (i2 < 0x100000) {
                testFileUtil.assertEquals(i2 ^ 0x53, read.readInt());
                ++i2;
            }
            read.close();
            file.close();
            System.gc();
            long startTime = System.currentTimeMillis();
            file = new RandomAccessFile(tmp1, "rw");
            BinaryFile.insertBytes(file, 0x200000L, 262144L);
            long elapsedTime = System.currentTimeMillis() - startTime;
            totInsertTime += elapsedTime;
            System.out.println("Insert 256kb in front of 2MB, time: " + elapsedTime);
            testFileUtil.assertEquals(0x440000L, file.length());
            read = new BinaryFile(file);
            read.position(0L);
            int i3 = 0;
            while (i3 < 524288) {
                testFileUtil.assertEquals(i3 ^ 0x53, read.readInt());
                ++i3;
            }
            read.position(0x240000L);
            i3 = 524288;
            while (i3 < 0x100000) {
                testFileUtil.assertEquals(i3 ^ 0x53, read.readInt());
                ++i3;
            }
            read.close();
            file.close();
            file = new RandomAccessFile(tmp1, "rw");
            System.gc();
            startTime = System.currentTimeMillis();
            BinaryFile.removeBytes(file, 0x200000L, 262144L);
            elapsedTime = System.currentTimeMillis() - startTime;
            totRemoveTime += elapsedTime;
            System.out.println("remove 256kb in front of 2,25MB, time: " + elapsedTime);
            testFileUtil.assertEquals(0x400000L, file.length());
            read = new BinaryFile(file);
            read.position(0L);
            i3 = 0;
            while (i3 < 0x100000) {
                testFileUtil.assertEquals(i3 ^ 0x53, read.readInt());
                ++i3;
            }
            read.close();
            ++iter;
        }
        System.out.println("Average insert time: " + totInsertTime / (long)iterCount);
        System.out.println("Average remove time: " + totRemoveTime / (long)iterCount);
        tmp1.delete();
    }
}

