/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.ObjectVariantBinding;
import org.simantics.databoard.file.FileList;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;

public class TestVariant
extends TestCase {
    VariantBinding binding;

    @Override
    public void setUp() throws Exception {
        ObjectVariantBinding b = (ObjectVariantBinding)Bindings.OBJECT;
        this.binding = b;
    }

    public void testObject() throws Exception {
        TestVariant.assertTrue(this.binding.isInstance("Y"));
        Object o1 = this.binding.create((Binding)Bindings.getBinding(String.class), "X");
        TestVariant.assertTrue(this.binding.getContentType(o1) instanceof StringType);
        TestVariant.assertTrue(this.binding.getContentBinding(o1) instanceof StringBinding);
        Object o2 = this.binding.create((Binding)Bindings.getBinding(Integer.class), 5);
        TestVariant.assertTrue(this.binding.getContentType(o2) instanceof IntegerType);
        TestVariant.assertTrue(this.binding.getContentBinding(o2) instanceof IntegerBinding);
        Object o3 = this.binding.create((Binding)Bindings.getBinding(int[].class), new int[]{1, 2, 3, 4});
        TestVariant.assertTrue(this.binding.getContentType(o3) instanceof ArrayType);
        TestVariant.assertTrue(this.binding.getContentBinding(o3) instanceof ArrayBinding);
        Object o4 = this.binding.create((Binding)Bindings.getBinding(Rectangle2D.Double.class), new Rectangle2D.Double(0.0, 0.0, 100.0, 10.0));
        TestVariant.assertTrue(this.binding.getContentType(o4) instanceof RecordType);
        TestVariant.assertTrue(this.binding.getContentBinding(o4) instanceof RecordBinding);
    }

    public void testSerialization() throws IOException, SerializerConstructionException, SerializationException, BindingConstructionException {
        File f = File.createTempFile("test", ".tmp");
        FileList list = new FileList(f, (Binding)this.binding);
        list.add("XYZ");
        list.add(5);
        list.add(0.2342);
        list.close();
        FileList list2 = new FileList(f, (Binding)Bindings.getBinding(Object.class));
        TestVariant.assertEquals(new MutableString("XYZ"), list2.get(0));
        TestVariant.assertEquals((Object)5, list2.get(1));
        TestVariant.assertEquals(0.2342, list2.get(2));
    }

    public void testAscii() throws IOException, BindingException, DataTypeSyntaxError {
        String o1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Integer o2 = 1234567890;
        Rectangle2D.Double o3 = new Rectangle2D.Double(50.0, 50.0, 100.0, 100.0);
        String s1 = this.binding.printValueDefinition(o1, true);
        String s2 = this.binding.printValueDefinition(o2, true);
        String s3 = this.binding.printValueDefinition(o3, true);
        System.out.println(s1);
        System.out.println(s2);
        System.out.println(s3);
        Object u1 = this.binding.parseValueDefinition(s1);
        Object u2 = this.binding.parseValueDefinition(s2);
        Object u3 = this.binding.parseValueDefinition(s3);
        TestVariant.assertEquals((Object)o1, u1);
        TestVariant.assertEquals(o2, u2);
        TestVariant.assertEquals(o3, u3);
    }
}

