/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.annotations.MIMEType;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Pattern;
import org.simantics.databoard.annotations.Range;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;

public class ParserSuccessTests
extends TestCase {
    DataTypeRepository repository;
    Map<String, Datatype> reference;

    @Override
    @Before
    public void setUp() {
        this.repository = new DataTypeRepository();
        this.reference = new HashMap<String, Datatype>();
    }

    public void printRepository() {
        for (String name : this.repository.getTypeNames()) {
            Datatype type = this.repository.get(name);
            System.out.println(String.valueOf(name) + " = " + type + " (" + type.getClass() + ")");
        }
    }

    @After
    public void compare() {
        for (String name : this.reference.keySet()) {
            if (this.repository.getTypeNames().contains(name)) continue;
            ParserSuccessTests.fail("Type " + name + " is not in repository.");
        }
        for (String name : this.repository.getTypeNames()) {
            if (this.reference.containsKey(name)) continue;
            ParserSuccessTests.fail("Type " + name + " should not be in the repository.");
        }
        for (String name : this.repository.getTypeNames()) {
            ParserSuccessTests.assertEquals("Problem with type " + name + ".", this.reference.get(name), this.repository.get(name));
        }
    }

    @Test
    public void testBuiltins() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type MyBoolean = Boolean type MyByte = Byte type MyInteger = Integer type MyLong = Long type MyFloat = Float type MyDouble = Double type MyString = String ");
        this.reference.put("MyBoolean", (Datatype)Datatypes.getDatatypeUnchecked(Boolean.class));
        this.reference.put("MyByte", (Datatype)Datatypes.getDatatypeUnchecked(Byte.class));
        this.reference.put("MyInteger", (Datatype)Datatypes.getDatatypeUnchecked(Integer.class));
        this.reference.put("MyFloat", (Datatype)Datatypes.getDatatypeUnchecked(Float.class));
        this.reference.put("MyDouble", (Datatype)Datatypes.getDatatypeUnchecked(Double.class));
        this.reference.put("MyLong", (Datatype)Datatypes.getDatatypeUnchecked(Long.class));
        this.reference.put("MyString", (Datatype)Datatypes.getDatatypeUnchecked(String.class));
    }

    @Test
    public void testArray() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Array1 = Integer[] type Array2 = String[][] ");
        this.reference.put("Array1", (Datatype)Datatypes.getDatatypeUnchecked(int[].class));
        this.reference.put("Array2", (Datatype)Datatypes.getDatatypeUnchecked(String[][].class));
    }

    @Test
    public void testOptional() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Optional1 = {a : Optional(Integer),b : Optional(Float[])}");
        this.reference.put("Optional1", (Datatype)Datatypes.getDatatypeUnchecked(Optional1.class));
    }

    @Test
    public void testRecord() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Record1 = {} type Record2 = { a : String, b : Integer } ");
        this.reference.put("Record1", (Datatype)Datatypes.getDatatypeUnchecked(Record1.class));
        this.reference.put("Record2", (Datatype)Datatypes.getDatatypeUnchecked(Record2.class));
    }

    public Datatype tuple(Datatype ... types) {
        RecordType tuple = new RecordType();
        Component[] components = new Component[types.length];
        int i = 0;
        while (i < types.length) {
            components[i] = new Component(Integer.toString(i), types[i]);
            ++i;
        }
        tuple.setComponents(components);
        return tuple;
    }

    @Test
    public void testTuple() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Tuple1 = () type Tuple2 = (Integer, String) type NotTuple = (Double) ");
        this.reference.put("Tuple1", (Datatype)Datatypes.getDatatypeUnchecked(Record1.class));
        this.reference.put("Tuple2", this.tuple(new Datatype[]{Datatypes.getDatatypeUnchecked(Integer.class), Datatypes.getDatatypeUnchecked(String.class)}));
        this.reference.put("NotTuple", (Datatype)Datatypes.getDatatypeUnchecked(Double.class));
    }

    @Test
    public void testUnion() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Union1 = | A /*             | B Integer */             | C { x : Float, y : Integer } ");
        this.reference.put("Union1", (Datatype)Datatypes.getDatatypeUnchecked(Union1.class));
    }

    @Test
    public void testReferences() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Ref1 = String type Ref2 = { a : Ref1, b : Ref3 } type Ref3 = Ref4 type Ref4 = Integer ");
        this.reference.put("Ref1", (Datatype)Datatypes.getDatatypeUnchecked(String.class));
        this.reference.put("Ref2", (Datatype)Datatypes.getDatatypeUnchecked(Record2.class));
        this.reference.put("Ref3", (Datatype)Datatypes.getDatatypeUnchecked(Integer.class));
        this.reference.put("Ref4", (Datatype)Datatypes.getDatatypeUnchecked(Integer.class));
    }

    @Test
    public void testRecursion() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Rec1 = { ref1 : Rec2[] } type Rec2 = { ref2 : Optional(Rec1) } ");
        this.reference.put("Rec1", (Datatype)Datatypes.getDatatypeUnchecked(Rec1.class));
        this.reference.put("Rec2", (Datatype)Datatypes.getDatatypeUnchecked(Rec2.class));
    }

    @Test
    public void testBuiltinAnnotations() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type BuiltinAnnotations = {a : Integer(range=[-9..10], unit=\"foo\"),b : Long(range=[0..3453453453345], unit=\"foo\"),c : Float(range=[-4.3..10], unit=\"foo\"),d : Double(range=[0..10.3], unit=\"foo\"),e : String(length=[0..10], mimeType=\"foo\", pattern=\"\\\\S{2,9}\")}");
        this.reference.put("BuiltinAnnotations", (Datatype)Datatypes.getDatatypeUnchecked(BuiltinAnnotations.class));
    }

    @Test
    public void testArrayAnnotations() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type ArrayAnnotations = {a : Float[2..],b : Double[..2],c : String[1..3],d : Byte[2]}");
        this.reference.put("ArrayAnnotations", (Datatype)Datatypes.getDatatypeUnchecked(ArrayAnnotations.class));
    }

    static class A
    implements Union1 {
        A() {
        }
    }

    static class ArrayAnnotations {
        @Length(value={"[2..]"})
        float[] a;
        @Length(value={"[2..]"})
        double[] b;
        @Length(value={"[1..3]"})
        String[] c;
        @Length(value={"2"})
        byte[] d;

        ArrayAnnotations() {
        }
    }

    static class B
    implements Union1 {
        int value;

        B() {
        }
    }

    static class BuiltinAnnotations {
        @Range(value="[-9..10]")
        @Unit(value="foo")
        int a;
        @Range(value="[0..3453453453345]")
        @Unit(value="foo")
        long b;
        @Range(value="[-4.3..10]")
        @Unit(value="foo")
        float c;
        @Range(value="[0..10.3]")
        @Unit(value="foo")
        double d;
        @Length(value={"0"})
        @MIMEType(value="foo")
        @Pattern(value="\\S{2,9}")
        String e;

        BuiltinAnnotations() {
        }
    }

    static class C
    implements Union1 {
        float x;
        int y;

        C() {
        }
    }

    static class Optional1 {
        @Optional
        Integer a;
        @Optional
        float[] b;

        Optional1() {
        }
    }

    static class Rec1 {
        Rec2[] ref1;

        Rec1() {
        }
    }

    static class Rec2 {
        @Optional
        Rec1 ref2;

        Rec2() {
        }
    }

    static class Record1 {
        Record1() {
        }
    }

    static class Record2 {
        String a;
        Integer b;

        Record2() {
        }
    }

    @Union(value={A.class, C.class})
    static interface Union1 {
    }
}

