/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.primitives;

import java.math.BigInteger;

public abstract class UnsignedLong
extends Number
implements Comparable<Number> {
    static final long serialVersionUID = 1L;
    static final long L_MIN_VALUE = 0L;
    static final BigInteger HALF = new BigInteger("9223372036854775808");
    static final BigInteger BI_MIN_VALUE = new BigInteger("0");
    static final BigInteger BI_MAX_VALUE = new BigInteger("18446744073709551615");
    public static final UnsignedLong MIN_VALUE;
    public static final UnsignedLong MAX_VALUE;
    public static final UnsignedLong ZERO;
    long value;
    private static int CACHE_SIZE;
    private static Immutable[] CACHE;

    static {
        CACHE_SIZE = 16;
        CACHE = new Immutable[CACHE_SIZE];
        int i = 0;
        while (i < CACHE_SIZE) {
            UnsignedLong.CACHE[i] = new Immutable(i);
            ++i;
        }
        ZERO = MIN_VALUE = CACHE[0];
        MAX_VALUE = UnsignedLong.fromBits(-1L);
    }

    public static UnsignedLong valueOf(long value) {
        if (value >= 0L && value < (long)CACHE.length) {
            return CACHE[(int)value];
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Argument is not within range");
        }
        return new Immutable(value);
    }

    public static UnsignedLong fromBits(long bits) {
        if (bits >= 0L && bits < (long)CACHE.length) {
            return CACHE[(int)bits];
        }
        Immutable result = new Immutable();
        result.value = bits;
        return result;
    }

    public long toBits() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public BigInteger toBigInteger() {
        return this.value >= 0L ? BigInteger.valueOf(this.value) : BigInteger.valueOf(this.value & Integer.MAX_VALUE).add(HALF);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnsignedLong)) {
            return false;
        }
        UnsignedLong other = (UnsignedLong)obj;
        return this.value == other.value;
    }

    public String toString() {
        return this.value >= 0L ? Long.toString(this.value) : this.toBigInteger().toString();
    }

    @Override
    public int compareTo(Number obj) {
        return this.value >= 0L ? Long.signum(this.value - obj.longValue()) : 1;
    }

    public int hashCode() {
        return (int)this.value | (int)(this.value >> 32);
    }

    public static final class Immutable
    extends UnsignedLong {
        private static final long serialVersionUID = 1L;

        Immutable() {
        }

        public Immutable(int value) throws IllegalArgumentException {
            if ((long)value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value;
        }

        public Immutable(long value) throws IllegalArgumentException {
            if (value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public Immutable(BigInteger value) throws IllegalArgumentException {
            if (value.compareTo(BI_MIN_VALUE) < 0 || value.compareTo(BI_MAX_VALUE) > 0) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value.compareTo(HALF) < 0 ? value.longValue() : value.subtract(HALF).longValue() | 0x80000000L;
        }

        public Immutable(String stringValue) throws IllegalArgumentException {
            long value = Long.parseLong(stringValue);
            if (value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }
    }

    public static class Mutable
    extends UnsignedLong {
        private static final long serialVersionUID = 1L;

        Mutable() {
        }

        public Mutable(int value) throws IllegalArgumentException {
            if ((long)value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value;
        }

        public Mutable(long value) throws IllegalArgumentException {
            if (value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public Mutable(BigInteger value) throws IllegalArgumentException {
            if (value.compareTo(BI_MIN_VALUE) < 0 || value.compareTo(BI_MAX_VALUE) > 0) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value.compareTo(HALF) < 0 ? value.longValue() : value.subtract(HALF).longValue() | 0x80000000L;
        }

        public Mutable(String stringValue) throws IllegalArgumentException {
            long value = Long.parseLong(stringValue);
            if (value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public static Mutable fromBits(long bits) {
            Mutable result = new Mutable();
            result.value = bits;
            return result;
        }

        public void setFromBits(int intBits) {
            this.value = intBits;
        }

        public void setValue(int value) {
            if ((long)value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value;
        }

        public void setValue(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = (int)value;
        }

        public void setValue(BigInteger value) {
            if (value.compareTo(BI_MIN_VALUE) < 0 || value.compareTo(BI_MAX_VALUE) > 0) {
                throw new IllegalArgumentException("Argument is not within range");
            }
            this.value = value.compareTo(HALF) < 0 ? value.longValue() : value.subtract(HALF).longValue() | 0x80000000L;
        }

        public static /* bridge */ /* synthetic */ UnsignedLong fromBits(long l) {
            return Mutable.fromBits(l);
        }
    }
}

