/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simantics.databoard.method.Handshake;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.TcpConnection;

public class Server {
    static Logger LOGGER = Logger.getLogger(Server.class.getName());
    ServerSocket socket;
    Thread acceptThread;
    MethodInterface handler;
    List<TcpConnection> connections = new CopyOnWriteArrayList<TcpConnection>();

    public Server(int port, MethodInterface handler) throws IOException {
        this.handler = handler;
        this.socket = new ServerSocket(port);
        this.acceptThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Socket s;
                    try {
                        s = Server.this.socket.accept();
                    }
                    catch (IOException e) {
                        return;
                    }
                    try {
                        Handshake local = new Handshake();
                        local.methods = Server.this.handler.getInterface().getMethodDefinitions();
                        Handshake remote = TcpConnection.handshake(s, local);
                        final TcpConnection c = new TcpConnection(s, Server.this.handler, local, remote);
                        c.addConnectionListener(new TcpConnection.ConnectionListener(){

                            @Override
                            public void onClosed() {
                                (this).Server.this.connections.remove(c);
                            }

                            @Override
                            public void onError(Exception error) {
                                (this).Server.this.connections.remove(c);
                            }
                        });
                        Server.this.connections.add(c);
                        if (!c.getSocket().isClosed()) continue;
                        Server.this.connections.remove(c);
                        continue;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINER, "Connection Closed");
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {
                        }
                        continue;
                    }
                    break;
                }
            }
        };
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (TcpConnection c : this.connections) {
            c.close();
            try {
                c.getSocket().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

