/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example.old;

import java.util.Arrays;
import org.simantics.databoard.Methods;
import org.simantics.databoard.method.Interface;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.MethodTypeBinding;

public class MethodInterfaceExample {
    public static final Interface commandProcessorInterface = Methods.getInterfaceTypeUnchecked(ICommandProcessor.class);

    public static void main(String[] args) throws Exception {
        String result;
        ICommandProcessor myProcessor = new ICommandProcessor(){

            @Override
            public String execute(String command, int ... args) throws Error1 {
                if (!command.equals("start")) {
                    throw new Error1("Unknown command " + command);
                }
                return "Program started " + command + " with args " + Arrays.toString(args);
            }
        };
        MethodInterface myProcessorBinding = Methods.bindInterface(commandProcessorInterface, myProcessor);
        MethodTypeBinding b = Methods.getMethodTypeBinding(ICommandProcessor.class.getMethod("execute", String.class, int[].class));
        MethodInterface.Method m = myProcessorBinding.getMethod(b);
        MethodInterface.AsyncResult res = m.invoke(new Object[]{"start", new int[]{666, 777}});
        System.out.println(res.waitForResponse());
        ICommandProcessor myProxy = Methods.createProxy(ICommandProcessor.class, myProcessorBinding);
        try {
            result = myProxy.execute("start", 5, 6, 72, 7423);
            System.out.println(result);
        }
        catch (Error1 e) {
            System.err.println(e);
        }
        try {
            result = myProxy.execute("fault", new int[0]);
            System.out.println(result);
        }
        catch (Error1 e) {
            System.err.println(e);
        }
    }

    public static class Error1
    extends Exception {
        private static final long serialVersionUID = 1L;
        public String msg;

        public Error1(String msg) {
            this.msg = msg;
        }

        @Override
        public String toString() {
            return this.msg;
        }
    }

    public static interface ICommandProcessor {
        public String execute(String var1, int ... var2) throws Error1;
    }
}

