/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example;

import java.io.File;
import java.util.Arrays;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.file.FileArrayAccessor;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;

public class FileAccessorExample {
    public static void main(String[] args) throws Exception {
        File file = File.createTempFile("variable", ".dbb");
        FileVariantAccessor fa = Accessors.createFile(file);
        fa.setContentValue(Bindings.STRING, "Hello World!");
        fa.setContentValue(Bindings.INTEGER, 500);
        fa.setContentValueNoflush(Bindings.DOUBLE, 99.0);
        fa.flush();
        fa.close();
        fa = Accessors.openAccessor(file);
        System.out.println(fa.getContentType());
        Double value = (Double)fa.getContentValue(Bindings.DOUBLE);
        System.out.println(value);
        ArrayType floatArrayType = new ArrayType(Datatypes.FLOAT);
        Object binding = Bindings.getMutableBinding(floatArrayType);
        fa.setContentValue((Binding)binding, ((Binding)binding).createDefault());
        FileArrayAccessor aa = (FileArrayAccessor)fa.getContentAccessor();
        int i = 0;
        while (i < 1024) {
            float v = (float)i * 1.5f;
            aa.addNoflush(Bindings.FLOAT, Float.valueOf(v));
            ++i;
        }
        aa.flush();
        System.out.print("[");
        i = 0;
        while (i < aa.size()) {
            System.out.print(aa.get(i, Bindings.FLOAT));
            System.out.print(", ");
            ++i;
        }
        System.out.println("]");
        binding = Bindings.getBinding(float[].class);
        float[] data = (float[])aa.getValue((Binding)binding);
        System.out.println(Arrays.toString(data));
        aa.close();
        Serializer s = Bindings.getSerializerUnchecked(Bindings.MUTABLE_VARIANT);
        MutableVariant variant = (MutableVariant)s.deserialize(file);
        data = (float[])variant.getValue((Binding)binding);
        System.out.println(Arrays.toString(data));
        file.delete();
    }
}

