/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example;

import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.impl.ChangeSet;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.binding.Binding;

public class AccessorExample {
    public static void main(String[] args) throws Exception {
        Rectangle2D.Double rect = new Rectangle2D.Double(10.0, 10.0, 200.0, 100.0);
        RecordAccessor ra = (RecordAccessor)Accessors.getAccessor(rect);
        System.out.println("Type: ");
        System.out.println(ra.type());
        ra.getFieldAccessor("x").setValue(Bindings.DOUBLE, 100.0);
        System.out.println(rect);
        InterestSet is = InterestSet.newInterestSet(ra.type(), true, true, true);
        Accessor.Listener listener = new Accessor.Listener(){

            @Override
            public void onEvents(Collection<Event> events) {
                for (Event e : events) {
                    System.out.println("Event occured: " + e);
                }
            }
        };
        ra.addListener(listener, is, null, null);
        ra.getFieldAccessor("y").setValue(Bindings.DOUBLE, 666.0);
        ra.removeListener(listener);
        ChangeSet changeSet = new ChangeSet();
        ra.addListener(changeSet, is, null, null);
        ra.setFieldValue(2, (Binding)Bindings.DOUBLE, (Object)10.0);
        ra.setFieldValue(3, (Binding)Bindings.DOUBLE, (Object)10.0);
        System.out.println(rect);
        ra.removeListener(changeSet);
        System.out.println();
        System.out.println("Collected changes:");
        for (Event e : changeSet.getEvents()) {
            System.out.println(" o " + e);
        }
        System.out.println();
        Rectangle2D.Double rect2 = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        LinkedList<Event> rollback = new LinkedList<Event>();
        Accessors.getAccessor(rect2).apply(changeSet.getAndClearEvents(), rollback);
        System.out.println(rect2);
        Accessors.getAccessor(rect2).apply(rollback, null);
        System.out.println(rect2);
        ra = null;
    }
}

