/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.wire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Methods;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.OptionalAccessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.wire.IWireClient;
import org.simantics.databoard.accessor.wire.IWireServer;
import org.simantics.databoard.accessor.wire.WireException;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.impl.ObjectArrayBinding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.MethodNotSupportedException;
import org.simantics.databoard.method.MethodTypeBinding;
import org.simantics.databoard.method.TcpConnection;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.BijectionMap;

public class WireServer
implements IWireServer {
    Accessor accessor;
    Map<TcpConnection, ClientRecord> clients = Collections.synchronizedMap(new HashMap());
    MethodInterface mi;
    AccessorParams params = AccessorParams.DEFAULT;

    public WireServer(Accessor accessor) {
        this.accessor = accessor;
        try {
            this.mi = Methods.bindInterface(IWireServer.class, this);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeException(e);
        }
    }

    public MethodInterface getMethodInterface() {
        return this.mi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRecord getClient() throws WireException {
        TcpConnection connection = TcpConnection.getCurrentConnection();
        if (connection == null) {
            throw new WireException("Internal Error. This method must be invoked in ConnectionThread");
        }
        try {
            Map<TcpConnection, ClientRecord> map = this.clients;
            synchronized (map) {
                ClientRecord handler = this.clients.get(connection);
                if (handler == null) {
                    RecordBinding requestBinding = (RecordBinding)Bindings.getBindingUnchecked(OnEventsRequest.class);
                    IntegerBinding responseBinding = Bindings.INTEGER;
                    UnionType ut = new UnionType();
                    ut.components = new Component[0];
                    UnionBinding errorBinding = (UnionBinding)this.params.bindingScheme.getBinding(ut);
                    MethodTypeBinding onEventsBinding = new MethodTypeBinding("onEvents", requestBinding, (Binding)responseBinding, errorBinding);
                    try {
                        handler = new ClientRecord();
                        handler.clientMethodInterface = connection.getRemoteMethodInterface();
                        handler.onEventsMethod = handler.clientMethodInterface.getMethod(onEventsBinding);
                        handler.connection = connection;
                        handler.clientMethods = Methods.createProxy(IWireClient.class, handler.connection.getRemoteMethodInterface());
                    }
                    catch (MethodNotSupportedException e) {
                        throw new WireException(e);
                    }
                    connection.addConnectionListener(new TcpConnection.ConnectionListener(){

                        @Override
                        public void onError(Exception error) {
                            TcpConnection connection = TcpConnection.getCurrentConnection();
                            ClientRecord handler = WireServer.this.clients.remove(connection);
                            handler.dispose();
                        }

                        @Override
                        public void onClosed() {
                            TcpConnection connection = TcpConnection.getCurrentConnection();
                            ClientRecord handler = WireServer.this.clients.remove(connection);
                            handler.dispose();
                        }
                    });
                    this.clients.put(connection, handler);
                }
                return handler;
            }
        }
        catch (BindingConstructionException e) {
            throw new WireException(e);
        }
    }

    AccRecord getAccessor(int accId) throws WireException {
        ClientRecord client = this.getClient();
        AccRecord acc = client.accessorTable.getRight(accId);
        if (acc == null) {
            throw new WireException("Invalid accessor id");
        }
        return acc;
    }

    LisRecord getListener(int accId, int lisId) throws WireException {
        ClientRecord client = this.getClient();
        LisRecord lis = client.listenerTable.get(lisId);
        return lis;
    }

    @Override
    public IWireServer.AccessorInfo openAccessor(ChildReference ref) throws WireException {
        try {
            ClientRecord client = this.getClient();
            AccRecord acc = new AccRecord();
            acc.accessor = this.accessor.getComponent(ref);
            acc.accId = client.accIdCounter++;
            acc.reference = ref;
            acc.type = this.accessor.type();
            acc.binding = this.params.bindingScheme.getBinding(acc.type);
            client.accessorTable.map(acc.accId, acc);
            IWireServer.AccessorInfo ai = new IWireServer.AccessorInfo();
            ai.accessorId = acc.accId;
            ai.type = acc.type;
            return ai;
        }
        catch (AccessorConstructionException e) {
            throw new WireException(e);
        }
        catch (BindingConstructionException e) {
            throw new WireException(e);
        }
    }

    @Override
    public int closeAccessors(Integer[] accIds) throws WireException {
        ClientRecord client = this.getClient();
        Integer[] integerArray = accIds;
        int n = accIds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer accId = integerArray[n2];
            client.accessorTable.removeWithLeft(accId);
            ++n2;
        }
        return 0;
    }

    @Override
    public MutableVariant getValue(int accId) throws WireException {
        try {
            AccRecord acc = this.getAccessor(accId);
            Object value = acc.accessor.getValue(acc.binding);
            return new MutableVariant(acc.binding, value);
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public IWireServer.ApplyResult apply(int accId, Event[] changeSet, boolean rollback) {
        IWireServer.ApplyResult result = new IWireServer.ApplyResult();
        result.rollbackLog = rollback ? new LinkedList() : null;
        try {
            AccRecord acc = this.getAccessor(accId);
            ArrayList<Event> changeSetList = new ArrayList<Event>(changeSet.length);
            Event[] eventArray = changeSet;
            int n = changeSet.length;
            int n2 = 0;
            while (n2 < n) {
                Event e = eventArray[n2];
                changeSetList.add(e);
                ++n2;
            }
            acc.accessor.apply(changeSetList, result.rollbackLog);
        }
        catch (WireException e) {
            result.error = e;
        }
        catch (AccessorException e) {
            result.error = new WireException(e);
        }
        return result;
    }

    @Override
    public int addListener(int accId, InterestSet interestSet, ChildReference path) throws WireException {
        try {
            ClientRecord client = this.getClient();
            AccRecord acc = this.getAccessor(accId);
            final LisRecord lis = new LisRecord();
            lis.accId = accId;
            lis.is = interestSet;
            lis.lisId = client.listIdCounter++;
            lis.listener = new Accessor.Listener(){

                @Override
                public void onEvents(Collection<Event> events) {
                    try {
                        ClientRecord client = WireServer.this.getClient();
                        Event[] eventArray = events.toArray(new Event[events.size()]);
                        OnEventsRequest req = new OnEventsRequest();
                        req.arg1 = lis.lisId;
                        req.arg2 = eventArray;
                        client.onEventsMethod.invoke(req);
                    }
                    catch (WireException wireException) {
                        // empty catch block
                    }
                }
            };
            acc.accessor.addListener(lis.listener, interestSet, path, null);
            client.listenerTable.put(lis.lisId, lis);
            return lis.lisId;
        }
        catch (AccessorException e) {
            throw new WireException(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
        }
    }

    @Override
    public int removeListener(int lisId) throws WireException {
        try {
            ClientRecord client = this.getClient();
            LisRecord lis = client.listenerTable.remove(lisId);
            AccRecord acc = this.getAccessor(lis.accId);
            acc.accessor.removeListener(lis.listener);
            return 0;
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public int size(int accId) throws WireException {
        try {
            Accessor acc = this.getAccessor((int)accId).accessor;
            if (acc instanceof ArrayAccessor) {
                return ((ArrayAccessor)acc).size();
            }
            if (acc instanceof RecordAccessor) {
                return ((RecordAccessor)acc).count();
            }
            if (acc instanceof MapAccessor) {
                return ((MapAccessor)acc).size();
            }
            if (acc instanceof UnionAccessor) {
                return ((UnionAccessor)acc).count();
            }
            throw new WireException("Cannot get size for " + acc.getClass().getName());
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public int clear(int accId) throws WireException {
        Accessor acc;
        block5: {
            block4: {
                try {
                    acc = this.getAccessor((int)accId).accessor;
                    if (!(acc instanceof ArrayAccessor)) break block4;
                    ArrayAccessor aa = (ArrayAccessor)acc;
                    aa.remove(0, aa.size());
                    return 0;
                }
                catch (AccessorException e) {
                    throw new WireException(e);
                }
            }
            if (!(acc instanceof MapAccessor)) break block5;
            ((MapAccessor)acc).clear();
            return 0;
        }
        throw new WireException("Cannot clear " + acc.getClass().getName());
    }

    @Override
    public boolean containsKey(int accId, MutableVariant key) throws WireException {
        try {
            Accessor acc = this.getAccessor((int)accId).accessor;
            if (!(acc instanceof MapAccessor)) {
                throw new WireException("Not a map");
            }
            MapAccessor ma = (MapAccessor)acc;
            return ma.containsKey(key.getBinding(), key.getValue());
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public boolean containsValue(int accId, MutableVariant value) throws WireException {
        try {
            Accessor acc = this.getAccessor((int)accId).accessor;
            if (!(acc instanceof MapAccessor)) {
                throw new WireException("Not a map");
            }
            MapAccessor ma = (MapAccessor)acc;
            return ma.containsValue(value.getBinding(), value.getValue());
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public MutableVariant getFirstKey(int accId) throws WireException {
        try {
            Accessor acc = this.getAccessor((int)accId).accessor;
            if (!(acc instanceof MapAccessor)) {
                throw new WireException("Not a map");
            }
            MapAccessor ma = (MapAccessor)acc;
            Binding keyBinding = this.params.bindingScheme.getBinding(((MapType)acc.type()).keyType);
            Object key = ma.getFirstKey(keyBinding);
            return new MutableVariant(keyBinding, key);
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
        catch (BindingConstructionException e) {
            throw new WireException(e);
        }
    }

    @Override
    public MutableVariant getLastKey(int accId) throws WireException {
        try {
            Accessor acc = this.getAccessor((int)accId).accessor;
            if (!(acc instanceof MapAccessor)) {
                throw new WireException("Not a map");
            }
            MapAccessor ma = (MapAccessor)acc;
            Binding keyBinding = this.params.bindingScheme.getBinding(((MapType)acc.type()).keyType);
            Object key = ma.getFirstKey(keyBinding);
            return new MutableVariant(keyBinding, key);
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
        catch (BindingConstructionException e) {
            throw new WireException(e);
        }
    }

    @Override
    public MutableVariant getLowerKey(int accId, MutableVariant key) throws WireException {
        Object lowerKey;
        Binding keyBinding;
        block4: {
            try {
                Accessor acc = this.getAccessor((int)accId).accessor;
                if (!(acc instanceof MapAccessor)) {
                    throw new WireException("Not a map");
                }
                MapAccessor ma = (MapAccessor)acc;
                keyBinding = key.getBinding();
                lowerKey = ma.getLowerKey(keyBinding, key.getValue());
                if (lowerKey != null) break block4;
                return null;
            }
            catch (AccessorException e) {
                throw new WireException(e);
            }
        }
        return new MutableVariant(keyBinding, lowerKey);
    }

    @Override
    public MutableVariant getFloorKey(int accId, MutableVariant key) throws WireException {
        Object floorKey;
        Binding keyBinding;
        block4: {
            try {
                Accessor acc = this.getAccessor((int)accId).accessor;
                if (!(acc instanceof MapAccessor)) {
                    throw new WireException("Not a map");
                }
                MapAccessor ma = (MapAccessor)acc;
                keyBinding = key.getBinding();
                floorKey = ma.getFloorKey(keyBinding, key.getValue());
                if (floorKey != null) break block4;
                return null;
            }
            catch (AccessorException e) {
                throw new WireException(e);
            }
        }
        return new MutableVariant(keyBinding, floorKey);
    }

    @Override
    public MutableVariant getCeilingKey(int accId, MutableVariant key) throws WireException {
        Object ceilingKey;
        Binding keyBinding;
        block4: {
            try {
                Accessor acc = this.getAccessor((int)accId).accessor;
                if (!(acc instanceof MapAccessor)) {
                    throw new WireException("Not a map");
                }
                MapAccessor ma = (MapAccessor)acc;
                keyBinding = key.getBinding();
                ceilingKey = ma.getCeilingKey(keyBinding, key.getValue());
                if (ceilingKey != null) break block4;
                return null;
            }
            catch (AccessorException e) {
                throw new WireException(e);
            }
        }
        return new MutableVariant(keyBinding, ceilingKey);
    }

    @Override
    public MutableVariant getHigherKey(int accId, MutableVariant key) throws WireException {
        Object higherKey;
        Binding keyBinding;
        block4: {
            try {
                Accessor acc = this.getAccessor((int)accId).accessor;
                if (!(acc instanceof MapAccessor)) {
                    throw new WireException("Not a map");
                }
                MapAccessor ma = (MapAccessor)acc;
                keyBinding = key.getBinding();
                higherKey = ma.getHigherKey(keyBinding, key.getValue());
                if (higherKey != null) break block4;
                return null;
            }
            catch (AccessorException e) {
                throw new WireException(e);
            }
        }
        return new MutableVariant(keyBinding, higherKey);
    }

    @Override
    public boolean hasValue(int accId) throws WireException {
        try {
            Accessor acc = this.getAccessor((int)accId).accessor;
            if (!(acc instanceof OptionalAccessor)) {
                throw new WireException("Not an option");
            }
            OptionalAccessor ma = (OptionalAccessor)acc;
            return ma.hasValue();
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public int getTag(int accId) throws WireException {
        try {
            Accessor acc = this.getAccessor((int)accId).accessor;
            if (!(acc instanceof UnionAccessor)) {
                throw new WireException("Not an union");
            }
            UnionAccessor ma = (UnionAccessor)acc;
            return ma.getTag();
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public int addAll(int accId, int index, MutableVariant array) throws WireException {
        try {
            ArrayAccessor acc = (ArrayAccessor)this.getAccessor((int)accId).accessor;
            Datatype type = array.type();
            if (!(type instanceof ArrayType)) {
                throw new WireException("addAll() array expepected, got " + array.type());
            }
            Binding componentBinding = ((ArrayBinding)array.getBinding()).getComponentBinding();
            ObjectArrayBinding binding = new ObjectArrayBinding((ArrayType)type, componentBinding);
            Object[] values = (Object[])array.getValue(binding);
            if (index == -1) {
                int size = acc.size();
                acc.addAll(binding, values);
                return size;
            }
            acc.addAll(index, binding, values);
            return index;
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
        catch (AdaptException e) {
            throw new WireException(e);
        }
    }

    @Override
    public int add(int accId, int index, MutableVariant value) throws WireException {
        try {
            ArrayAccessor acc = (ArrayAccessor)this.getAccessor((int)accId).accessor;
            if (index == -1) {
                int size = acc.size();
                acc.add(value.getBinding(), value.getValue());
                return size;
            }
            acc.add(index, value.getBinding(), value.getValue());
            return index;
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public MutableVariant getArrayElement(int accId, int index) throws WireException {
        try {
            AccRecord ar = this.getAccessor(accId);
            ArrayAccessor acc = (ArrayAccessor)ar.accessor;
            Binding valueBinding = ((ArrayBinding)ar.binding).getComponentBinding();
            Object value = acc.get(index, valueBinding);
            MutableVariant v = new MutableVariant(valueBinding, value);
            return v;
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public MutableVariant getMapValue(int accId, MutableVariant key) throws WireException {
        try {
            AccRecord ar = this.getAccessor(accId);
            MapAccessor acc = (MapAccessor)ar.accessor;
            MapBinding mapBinding = (MapBinding)ar.binding;
            Object value = acc.get(key.getBinding(), key.getValue(), mapBinding.getValueBinding());
            return new MutableVariant(mapBinding.getValueBinding(), value);
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public MutableVariant getMapValues(int accId) throws WireException {
        try {
            AccRecord ar = this.getAccessor(accId);
            MapAccessor acc = (MapAccessor)ar.accessor;
            MapBinding mapBinding = (MapBinding)ar.binding;
            Binding valueBinding = mapBinding.getValueBinding();
            Object[] values = acc.getValues(valueBinding);
            ObjectArrayBinding arrayBinding = new ObjectArrayBinding(new ArrayType(valueBinding.type()), valueBinding);
            return new MutableVariant(arrayBinding, values);
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    @Override
    public MutableVariant getMapKeys(int accId) throws WireException {
        try {
            AccRecord ar = this.getAccessor(accId);
            MapAccessor acc = (MapAccessor)ar.accessor;
            MapBinding mapBinding = (MapBinding)ar.binding;
            Binding keyBinding = mapBinding.getKeyBinding();
            Object[] keys = acc.getKeys(keyBinding);
            ObjectArrayBinding arrayBinding = new ObjectArrayBinding(new ArrayType(keyBinding.type()), keyBinding);
            return new MutableVariant(arrayBinding, keys);
        }
        catch (AccessorException e) {
            throw new WireException(e);
        }
    }

    static class AccRecord {
        int accId;
        Accessor accessor;
        ChildReference reference;
        Datatype type;
        Binding binding;

        AccRecord() {
        }
    }

    static class ClientRecord {
        TcpConnection connection;
        MethodInterface clientMethodInterface;
        MethodInterface.Method onEventsMethod;
        IWireClient clientMethods;
        int accIdCounter = 0;
        int listIdCounter = 0;
        BijectionMap<Integer, AccRecord> accessorTable = new BijectionMap();
        Map<Integer, LisRecord> listenerTable = new HashMap<Integer, LisRecord>();

        ClientRecord() {
        }

        public void dispose() {
        }
    }

    static class LisRecord {
        int lisId;
        int accId;
        InterestSet is;
        Accessor.Listener listener;

        LisRecord() {
        }
    }

    static class OnEventsRequest {
        @Optional
        public Integer arg1;
        @Optional
        public Event[] arg2;

        OnEventsRequest() {
        }
    }
}

