/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import java.lang.ref.SoftReference;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.OptionalAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.OptionalValueAssigned;
import org.simantics.databoard.accessor.event.OptionalValueRemoved;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.OptionalInterestSet;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.OptionalType;

public class JavaOptional
extends JavaObject
implements OptionalAccessor {
    SoftReference<JavaObject> component;

    public JavaOptional(Accessor parent, OptionalBinding binding, Object object, AccessorParams params) {
        super(parent, binding, object, params);
    }

    @Override
    public OptionalBinding getBinding() {
        return (OptionalBinding)this.binding;
    }

    @Override
    public OptionalType type() {
        return this.getBinding().type();
    }

    @Override
    public <T extends Accessor> T getComponentAccessor() throws AccessorConstructionException {
        block8: {
            if (this.getBinding().hasValue(this.object)) break block8;
            return null;
        }
        try {
            JavaObject sa = this.getExistingAccessor();
            if (sa == null) {
                Binding cb = this.getBinding().getComponentBinding();
                Object cv = this.getBinding().getValue(this.object);
                sa = JavaOptional.createSubAccessor(this, cb, cv, this.params);
                this.component = new SoftReference<JavaObject>(sa);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    OptionalInterestSet is = (OptionalInterestSet)le.getInterestSet();
                    InterestSet cis = is.getComponentInterest();
                    if (cis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new ComponentReference());
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            return (T)sa;
        }
        catch (BindingException e) {
            throw new AccessorConstructionException(e);
        }
    }

    JavaObject getExistingAccessor() {
        SoftReference<JavaObject> ref = this.component;
        JavaObject accessor = ref != null ? ref.get() : null;
        return accessor;
    }

    @Override
    public Object getComponentValue(Binding componentBinding) throws AccessorException {
        this.readLock();
        try {
            if (!this.getBinding().hasValue(this.object)) {
                throw new AccessorException("There is no component value");
            }
            Binding cb = this.getBinding().getComponentBinding();
            Object cv = this.getBinding().getValue(this.object);
            Object object = this.adapt(cv, cb, componentBinding);
            return object;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        super.addListener(listener, interestSet, path, executor);
        OptionalInterestSet is = (OptionalInterestSet)interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null) {
            return;
        }
        JavaObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        ChildReference childPath = ChildReference.concatenate(path, new ComponentReference());
        sa.addListener(listener, cis, childPath, executor);
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        OptionalInterestSet is = (OptionalInterestSet)e.interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null) {
            return;
        }
        JavaObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        sa.removeListener(listener);
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            if (lr.label.equals("o")) {
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
        }
        if (reference instanceof ComponentReference) {
            T result = this.getComponentAccessor();
            if (reference.getChildReference() != null) {
                result = result.getComponent(reference.getChildReference());
            }
            return result;
        }
        throw new ReferenceException(reference.getClass() + " is not a reference of OptionalType");
    }

    @Override
    public void setValue(Binding binding, Object newValue) throws AccessorException {
        this.writeLock();
        try {
            try {
                OptionalBinding rb = (OptionalBinding)binding;
                Object rv = newValue;
                boolean rvHasValue = rb.hasValue(newValue);
                if (rvHasValue) {
                    Binding rcb = rb.getComponentBinding();
                    Object rcv = rb.getValue(rv);
                    this.setComponentValue(rcb, rcv);
                } else {
                    this.setNoValue();
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public boolean hasValue() throws AccessorException {
        this.readLock();
        try {
            boolean bl = this.getBinding().hasValue(this.object);
            return bl;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setNoValue() throws AccessorException {
        this.writeLock();
        try {
            boolean hadValue = this.getBinding().hasValue(this.object);
            if (!hadValue) {
                return;
            }
            try {
                this.getBinding().setNoValue(this.object);
                JavaObject sa = this.getExistingAccessor();
                this.component = null;
                if (sa != null) {
                    sa.invalidatedNotification();
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    OptionalInterestSet is = (OptionalInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        OptionalValueRemoved e = new OptionalValueRemoved();
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setComponentValue(Binding binding, Object value) throws AccessorException {
        this.writeLock();
        try {
            Binding rcb = binding;
            Object rcv = value;
            boolean hadValue = this.getBinding().hasValue(this.object);
            JavaObject sa = this.getExistingAccessor();
            if (sa != null) {
                assert (hadValue);
                sa.setValue(rcb, rcv);
                return;
            }
            try {
                Binding lcb = this.getBinding().getComponentBinding();
                Object lcv = this.adapt(rcv, rcb, lcb);
                this.getBinding().setValue(this.object, lcv);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    OptionalInterestSet is = (OptionalInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        MutableVariant newComponentValue = null;
                        if (is.inValues()) {
                            newComponentValue = new MutableVariant(lcb, lcb.isImmutable() ? lcv : lcb.clone(lcv));
                        }
                        OptionalValueAssigned e = new OptionalValueAssigned(newComponentValue);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        try {
            ModificationEvent rollback = null;
            if (makeRollback) {
                OptionalBinding b = this.getBinding();
                Binding cb = this.getBinding().getComponentBinding();
                ModificationEvent modificationEvent = rollback = this.hasValue() ? new OptionalValueAssigned(cb, b.getValue(this.object)) : new OptionalValueRemoved();
            }
            if (e instanceof ValueAssigned) {
                ValueAssigned va = (ValueAssigned)e;
                this.setValue(va.newValue.getBinding(), va.newValue.getValue());
                return rollback;
            }
            if (e instanceof OptionalValueAssigned) {
                OptionalValueAssigned oa = (OptionalValueAssigned)e;
                if (oa.newValue == null) {
                    throw new AccessorException("Cannot apply field assignment event, the value is missing");
                }
                this.setComponentValue(oa.newValue.getBinding(), oa.newValue.getValue());
            } else if (e instanceof OptionalValueRemoved) {
                this.setNoValue();
            } else {
                throw new AccessorException("Unexpected event type " + e.getClass().getName() + " for an Optional Type");
            }
            return rollback;
        }
        catch (BindingException be) {
            throw new AccessorException(be);
        }
    }
}

