/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.CloseableAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.ArrayElementAdded;
import org.simantics.databoard.accessor.event.ArrayElementRemoved;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileArrayAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.ArrayInterestSet;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class BinaryVariableWidthStreamArray
extends BinaryObject
implements ArrayAccessor,
FileArrayAccessor,
ArrayAccessor.CloseableArrayAccessor,
StreamAccessor {
    TreeMap<Integer, Reference<BinaryObject>> children = new TreeMap();
    Binding cb;
    Serializer cs;
    Integer constantSize;
    ArrayAccessor index;

    public BinaryVariableWidthStreamArray(BinaryObject parent, Blob blob, Datatype type, AccessorParams params, ArrayAccessor index) throws AccessorConstructionException {
        super(parent, blob, type, params);
        ArrayType at = (ArrayType)type;
        this.cb = params.bindingScheme.getBindingUnchecked(at.componentType);
        this.cs = params.serializerScheme.getSerializerUnchecked(this.cb);
        this.constantSize = this.cs.getConstantSize();
        if (index == null || !(index.type().componentType instanceof LongType)) {
            throw new AccessorConstructionException("Index must be Long[]");
        }
        this.index = index;
    }

    @Override
    public ArrayType type() {
        return (ArrayType)this.type;
    }

    BinaryObject getExistingAccessor(int index) {
        Reference<BinaryObject> ref = this.children.get(index);
        if (ref == null) {
            return null;
        }
        BinaryObject res = ref.get();
        return res;
    }

    long getStartPosition(int fieldIndex) throws AccessorException {
        int c = this.index.size();
        if (fieldIndex == c) {
            try {
                return this.b.length();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        if (fieldIndex > c || fieldIndex < 0) {
            throw new AccessorException("Index out of bounds");
        }
        return (Long)this.index.get(fieldIndex, Bindings.LONG);
    }

    long getLength(int index, long pos) throws AccessorException {
        int c = this.index.size();
        if (index >= c || index < 0) {
            return 0L;
        }
        if (index == c - 1) {
            try {
                return this.b.length() - (Long)this.index.get(c - 1, Bindings.LONG);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        return (Long)this.index.get(index + 1, Bindings.LONG) - (Long)this.index.get(index, Bindings.LONG);
    }

    @Override
    public void setNoflush(int index, Binding rcb, Object rcv) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            int count = this.size();
            if (index == count) {
                this.addNoflush(count, rcb, rcv);
                return;
            }
            try {
                Serializer rcs = this.params.serializerScheme.getSerializer(rcb);
                long pos = this.getStartPosition(index);
                long oldSize = this.getLength(index, pos);
                long newSize = rcs.getSize(rcv, null);
                this.b.position(pos);
                long diff = newSize - oldSize;
                if (diff > 0L) {
                    this.b.insertBytes(newSize - oldSize, RandomAccessBinary.ByteSide.Right);
                } else if (diff < 0L) {
                    this.b.removeBytes(oldSize - newSize, RandomAccessBinary.ByteSide.Right);
                }
                this.b.position(pos);
                rcs.serialize(this.b, null, rcv);
                if (diff != 0L) {
                    int i = index + 1;
                    while (i < count) {
                        long p = (Long)this.index.get(i, Bindings.LONG);
                        this.index.set(i, Bindings.LONG, p += diff);
                        ++i;
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(index)) {
                        MutableVariant newValue = null;
                        if (is.inValues()) {
                            newValue = new MutableVariant(rcb, rcb.isImmutable() ? rcv : rcb.clone(rcv));
                        }
                        ValueAssigned e = new ValueAssigned(new IndexReference(index), newValue);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValueNoflush(Binding arrayBinding, Object newArray) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                ArrayInterestSet is;
                ListenerEntry le;
                ArrayBinding rb = (ArrayBinding)arrayBinding;
                Binding rcb = rb.getComponentBinding();
                Serializer rcs = this.params.serializerScheme.getSerializer(rcb);
                int oldCount = this.index.size();
                int newCount = rb.size(newArray);
                this.b.setLength(this.params.serializerScheme.getSerializer(rb).getSize(newArray));
                this.index.setSize(newCount);
                int index = 0;
                while (index < newCount) {
                    Object obj = rb.get(newArray, index);
                    this.index.set(index, Bindings.LONG, this.b.position());
                    rcs.serialize(this.b, obj);
                    ++index;
                }
                index = oldCount - 1;
                while (index >= newCount) {
                    BinaryObject sa = this.getExistingAccessor(index);
                    if (sa != null) {
                        sa.invalidatedNotification();
                        this.children.remove(index);
                        sa = null;
                    }
                    le = this.listeners;
                    while (le != null) {
                        is = (ArrayInterestSet)le.getInterestSet();
                        if (is.inNotificationsOf(index)) {
                            ArrayElementRemoved e = new ArrayElementRemoved(index);
                            this.emitEvent(le, e);
                        }
                        le = le.next;
                    }
                    --index;
                }
                if (this.listeners != null) {
                    index = 0;
                    while (index < newCount) {
                        Object cv = rb.get(newArray, index);
                        le = this.listeners;
                        while (le != null) {
                            is = (ArrayInterestSet)le.getInterestSet();
                            if (is.inNotificationsOf(index)) {
                                MutableVariant vv = null;
                                if (is.inValues()) {
                                    vv = new MutableVariant(rcb, this.cb.isImmutable() ? cv : rcb.clone(cv));
                                }
                                ModificationEvent e = index < oldCount ? new ValueAssigned(new IndexReference(index), vv) : new ArrayElementAdded(index, vv);
                                this.emitEvent(le, e);
                            }
                            le = le.next;
                        }
                        ++index;
                    }
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addNoflush(int index, Binding rcb, Object rcv) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                boolean lastEntry;
                Serializer rcs = this.params.serializerScheme.getSerializer(rcb);
                int oldCount = this.index.size();
                int newCount = oldCount + 1;
                boolean bl = lastEntry = index == oldCount;
                if (index > oldCount) {
                    throw new AccessorException("Index out of range");
                }
                long pos = this.getStartPosition(index);
                int size = rcs.getSize(rcv);
                this.b.position(pos);
                this.b.insertBytes(size, RandomAccessBinary.ByteSide.Left);
                rcs.serialize(this.b, null, rcv);
                this.index.add(index, Bindings.LONG, pos);
                int i = index + 1;
                while (i < newCount) {
                    long p = (Long)this.index.get(i, Bindings.LONG);
                    this.index.set(i, Bindings.LONG, p += (long)size);
                    ++i;
                }
                if (!lastEntry && !this.children.isEmpty()) {
                    Integer key = this.children.lastKey();
                    while (key != null && key >= index) {
                        Reference<BinaryObject> value = this.children.remove(key);
                        if (value.get() != null) {
                            this.children.put(key + 1, value);
                        }
                        key = this.children.lowerKey(key);
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        MutableVariant newValue = null;
                        if (is.inValues()) {
                            newValue = new MutableVariant(rcb, rcb.isImmutable() ? rcv : rcb.clone(rcv));
                        }
                        ArrayElementAdded e = new ArrayElementAdded(index, newValue);
                        this.emitEvent(le, e);
                    }
                    if (is.componentInterests != null) {
                        Map<Integer, InterestSet> oldCis = is.componentInterests;
                        boolean needUpdates = false;
                        for (Integer i2 : oldCis.keySet()) {
                            if (needUpdates |= i2 >= index) break;
                        }
                        if (needUpdates) {
                            HashMap<Integer, InterestSet> newCis = new HashMap<Integer, InterestSet>(oldCis.size());
                            Iterator<Integer> iterator = oldCis.keySet().iterator();
                            while (iterator.hasNext()) {
                                Integer i3;
                                Integer oldKey = i3 = iterator.next();
                                Integer newKey = i3 >= index ? i3 + 1 : i3;
                                InterestSet oldValue = oldCis.get(oldKey);
                                newCis.put(newKey, oldValue);
                            }
                            is.componentInterests = newCis;
                        }
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addNoflush(Binding binding, Object value) throws AccessorException {
        this.addNoflush(this.size(), binding, value);
    }

    @Override
    public void addAllNoflush(Binding binding, Object[] values) throws AccessorException {
        this.addAllNoflush(this.size(), binding, values);
    }

    @Override
    public void addAllNoflush(int index, Binding rcb, Object[] rcvs) throws AccessorException {
        if (index < 0 || index > this.size()) {
            throw new AccessorException("Index out of bounds");
        }
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                Serializer rcs = this.params.serializerScheme.getSerializer(rcb);
                this.b.position(0L);
                int repeatCount = rcvs.length;
                int oldCount = this.b.readInt();
                int newCount = oldCount + rcvs.length;
                if (index > oldCount) {
                    throw new AccessorException("Index out of range");
                }
                boolean lastEntry = index == oldCount;
                long size = 0L;
                int i = 0;
                while (i < rcvs.length) {
                    size += (long)rcs.getSize(rcvs[i]);
                    ++i;
                }
                long pos = this.getStartPosition(index);
                this.b.position(pos);
                this.b.insertBytes(size, RandomAccessBinary.ByteSide.Right);
                long p = pos;
                int i2 = 0;
                while (i2 < repeatCount) {
                    this.index.add(index + i2, Bindings.LONG, p);
                    p += (long)rcs.getSize(rcvs[i2]);
                    ++i2;
                }
                i2 = index + repeatCount;
                while (i2 < newCount) {
                    p = (Long)this.index.get(i2, Bindings.LONG);
                    this.index.set(i2, Bindings.LONG, p += size);
                    ++i2;
                }
                this.b.position(pos);
                i2 = 0;
                while (i2 < rcvs.length) {
                    Object rcv = rcvs[i2];
                    rcs.serialize(this.b, rcv);
                    ++i2;
                }
                if (!lastEntry && !this.children.isEmpty()) {
                    Integer key = this.children.lastKey();
                    while (key != null && key >= index) {
                        Reference<BinaryObject> value = this.children.remove(key);
                        if (value.get() != null) {
                            this.children.put(key + rcvs.length, value);
                        }
                        key = this.children.lowerKey(key);
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        int i3 = 0;
                        while (i3 < rcvs.length) {
                            MutableVariant newValue = null;
                            if (is.inValues()) {
                                newValue = new MutableVariant(rcb, rcb.isImmutable() ? rcvs[i3] : this.cb.clone(rcvs[i3]));
                            }
                            ArrayElementAdded e = new ArrayElementAdded(index, newValue);
                            this.emitEvent(le, e);
                            ++i3;
                        }
                    }
                    if (is.componentInterests != null) {
                        Map<Integer, InterestSet> oldCis = is.componentInterests;
                        boolean needUpdates = false;
                        for (Integer i4 : oldCis.keySet()) {
                            if (needUpdates |= i4 >= index) break;
                        }
                        if (needUpdates) {
                            HashMap<Integer, InterestSet> newCis = new HashMap<Integer, InterestSet>(oldCis.size());
                            Iterator<Integer> iterator = oldCis.keySet().iterator();
                            while (iterator.hasNext()) {
                                Integer i5;
                                Integer oldKey = i5 = iterator.next();
                                Integer newKey = i5 >= index ? i5 + rcvs.length : i5;
                                InterestSet oldValue = oldCis.get(oldKey);
                                newCis.put(newKey, oldValue);
                            }
                            is.componentInterests = newCis;
                        }
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void addRepeatNoflush(int index, Binding rcb, Object obj, int repeatCount) throws AccessorException {
        if (index < 0 || index > this.size()) {
            throw new AccessorException("Index out of bounds");
        }
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                Serializer rcs = this.params.serializerScheme.getSerializer(rcb);
                this.b.position(0L);
                int oldCount = this.index.size();
                int newCount = oldCount + repeatCount;
                if (index > oldCount) {
                    throw new AccessorException("Index out of range");
                }
                boolean lastEntry = index == oldCount;
                long componentSize = rcs.getSize(obj);
                long size = componentSize * (long)repeatCount;
                long pos = this.getStartPosition(index);
                this.b.position(pos);
                this.b.insertBytes(size, RandomAccessBinary.ByteSide.Right);
                long p = pos;
                int i = 0;
                while (i < repeatCount) {
                    this.index.add(index + i, Bindings.LONG, p);
                    pos += componentSize;
                    ++i;
                }
                i = index + repeatCount;
                while (i < newCount) {
                    p = (Long)this.index.get(i, Bindings.LONG);
                    this.index.set(i, Bindings.LONG, p += size);
                    ++i;
                }
                this.b.position(pos);
                i = 0;
                while (i < repeatCount) {
                    rcs.serialize(this.b, obj);
                    ++i;
                }
                if (!lastEntry && !this.children.isEmpty()) {
                    Integer key = this.children.lastKey();
                    while (key != null && key >= index) {
                        Reference<BinaryObject> value = this.children.remove(key);
                        if (value.get() != null) {
                            this.children.put(key + repeatCount, value);
                        }
                        key = this.children.lowerKey(key);
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        int i2 = 0;
                        while (i2 < repeatCount) {
                            MutableVariant newValue = null;
                            if (is.inValues()) {
                                newValue = new MutableVariant(rcb, obj);
                            }
                            ArrayElementAdded e = new ArrayElementAdded(index, newValue);
                            this.emitEvent(le, e);
                            ++i2;
                        }
                    }
                    if (is.componentInterests != null) {
                        Map<Integer, InterestSet> oldCis = is.componentInterests;
                        boolean needUpdates = false;
                        for (Integer i3 : oldCis.keySet()) {
                            if (needUpdates |= i3 >= index) break;
                        }
                        if (needUpdates) {
                            HashMap<Integer, InterestSet> newCis = new HashMap<Integer, InterestSet>(oldCis.size());
                            Iterator<Integer> iterator = oldCis.keySet().iterator();
                            while (iterator.hasNext()) {
                                Integer i4;
                                Integer oldKey = i4 = iterator.next();
                                Integer newKey = i4 >= index ? i4 + repeatCount : i4;
                                InterestSet oldValue = oldCis.get(oldKey);
                                newCis.put(newKey, oldValue);
                            }
                            is.componentInterests = newCis;
                        }
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void removeNoflush(int index, int count) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                boolean lastEntry = index == count;
                int oldCount = this.index.size();
                int newCount = oldCount - count;
                if (index < 0 || index + count > oldCount) {
                    throw new AccessorException("Index out of bounds");
                }
                long pos = this.getStartPosition(index);
                long lastPos = this.getStartPosition(index + count - 1);
                long lastLen = this.getLength(index, lastPos);
                long end = lastPos + lastLen;
                long len = end - pos;
                this.b.position(pos);
                this.b.removeBytes(len, RandomAccessBinary.ByteSide.Right);
                this.index.remove(index, count);
                int i = index;
                while (i < newCount) {
                    long p = (Long)this.index.get(i, Bindings.LONG);
                    this.index.set(i, Bindings.LONG, p -= len);
                    ++i;
                }
                NavigableMap<Integer, Reference<BinaryObject>> sm = this.children.subMap(index, true, index + count, false);
                for (Map.Entry e : sm.entrySet()) {
                    BinaryObject bo = (BinaryObject)((Reference)e.getValue()).get();
                    if (bo == null) continue;
                    bo.invalidatedNotification();
                }
                sm.clear();
                if (!lastEntry && !this.children.isEmpty()) {
                    Integer lastKey = this.children.lastKey();
                    Integer key = this.children.higherKey(index);
                    while (key != null && key <= lastKey) {
                        Reference<BinaryObject> value = this.children.remove(key);
                        if (value.get() != null) {
                            this.children.put(key - count, value);
                        }
                        key = this.children.higherKey(key);
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        ArrayElementRemoved e = new ArrayElementRemoved(index);
                        this.emitEvent(le, e);
                    }
                    if (is.componentInterests != null) {
                        Map<Integer, InterestSet> oldCis = is.componentInterests;
                        boolean needUpdates = false;
                        for (Integer i2 : oldCis.keySet()) {
                            if (needUpdates |= i2 >= index) break;
                        }
                        if (needUpdates) {
                            HashMap<Integer, InterestSet> newCis = new HashMap<Integer, InterestSet>(oldCis.size());
                            Iterator<Integer> iterator = oldCis.keySet().iterator();
                            while (iterator.hasNext()) {
                                Integer i3;
                                Integer oldKey = i3 = iterator.next();
                                Integer newKey = i3 >= index ? i3 - 1 : i3;
                                InterestSet oldValue = oldCis.get(oldKey);
                                newCis.put(newKey, oldValue);
                            }
                            is.componentInterests = newCis;
                        }
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public Object get(int index, Binding valueBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            long pos = this.getStartPosition(index);
            this.b.position(pos);
            Serializer s = this.params.serializerScheme.getSerializer(valueBinding);
            Object object = s.deserialize(this.b);
            return object;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void get(int index, Binding valueBinding, Object dst) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            try {
                long pos = this.getStartPosition(index);
                this.b.position(pos);
                Serializer s = this.params.serializerScheme.getSerializer(valueBinding);
                s.deserializeTo(this.b, dst);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getAccessor(int index) throws AccessorConstructionException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            int count = this.b.readInt();
            if (index < 0 || index >= count) {
                throw new ReferenceException("Element index (" + index + ") out of bounds (" + count + ")");
            }
            BinaryObject sa = this.getExistingAccessor(index);
            if (sa == null) {
                long pos = this.getStartPosition(index);
                long len = this.getLength(index, pos);
                sa = this.createSubAccessor(this.cb.type(), pos, len, this.params);
                this.children.put(index, new WeakReference<BinaryObject>(sa));
                ListenerEntry le = this.listeners;
                while (le != null) {
                    InterestSet cis;
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    InterestSet gis = is.getComponentInterest();
                    if (gis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new IndexReference(index));
                            sa.addListener(le.listener, gis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    if ((cis = is.getComponentInterest(index)) != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new IndexReference(index));
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            BinaryObject binaryObject = sa;
            return (T)binaryObject;
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            throw new AccessorConstructionException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            try {
                Integer index = new Integer(lr.label);
                T result = this.getAccessor(index);
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            catch (NumberFormatException nfe) {
                throw new ReferenceException(nfe);
            }
        }
        if (reference instanceof IndexReference) {
            IndexReference ref = (IndexReference)reference;
            int index = ref.getIndex();
            T result = this.getAccessor(index);
            if (reference.getChildReference() != null) {
                result = result.getComponent(reference.getChildReference());
            }
            return result;
        }
        throw new ReferenceException(String.valueOf(reference.getClass().getName()) + " is not a reference of an array");
    }

    @Override
    public void getAll(Binding valueBinding, Object[] array) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            try {
                this.b.position(0L);
                int size = this.b.readInt();
                if (size > array.length) {
                    throw new AccessorException("Argument array too short");
                }
                Serializer s = this.params.serializerScheme.getSerializer(valueBinding);
                int i = 0;
                while (i < size) {
                    array[i] = s.deserialize(this.b);
                    ++i;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getAll(Binding valueBinding, Collection<Object> values) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            try {
                this.b.position(0L);
                int size = this.b.readInt();
                Serializer s = this.params.serializerScheme.getSerializer(valueBinding);
                int i = 0;
                while (i < size) {
                    values.add(s.deserialize(this.b));
                    ++i;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setSizeNoflush(int newSize) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                int oldSize = this.size();
                if (newSize < oldSize) {
                    this.remove(newSize, oldSize - newSize);
                }
                if (newSize > oldSize) {
                    Object dummy = this.cb.createDefault();
                    int count = newSize - oldSize;
                    this.addRepeatNoflush(oldSize, this.cb, dummy, count);
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setSize(int newSize) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setSizeNoflush(newSize);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public int size() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        return this.index.size();
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ModificationEvent rollback = null;
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            if (makeRollback) {
                rollback = new ValueAssigned(this.cb, this.getValue(this.cb));
            }
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
        } else if (e instanceof ArrayElementAdded) {
            ArrayElementAdded aa = (ArrayElementAdded)e;
            this.addNoflush(aa.index, aa.value.getBinding(), aa.value.getValue());
            if (makeRollback) {
                rollback = new ArrayElementRemoved(aa.index);
            }
        } else if (e instanceof ArrayElementRemoved) {
            ArrayElementRemoved ar = (ArrayElementRemoved)e;
            if (ar.index < 0 || ar.index >= this.size()) {
                throw new AccessorException("Array index out of bounds");
            }
            if (makeRollback) {
                Object cv = this.get(ar.index, this.cb);
                rollback = new ArrayElementAdded(ar.index, new MutableVariant(this.cb, cv));
            }
            this.removeNoflush(ar.index, 1);
        } else {
            throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Array");
        }
        return rollback;
    }

    @Override
    public void add(Binding binding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.addNoflush(binding, value);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void add(int index, Binding binding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.addNoflush(index, binding, value);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addAll(Binding binding, Object[] values) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.addAllNoflush(binding, values);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addAll(int index, Binding binding, Object[] values) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.addAllNoflush(index, binding, values);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void remove(int index, int count) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.removeNoflush(index, count);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void set(int index, Binding binding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setNoflush(index, binding, value);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void close() throws AccessorException {
        if (this.index instanceof CloseableAccessor) {
            CloseableAccessor ca = (CloseableAccessor)((Object)this.index);
            ca.close();
        }
        super.close();
    }
}

