/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.OptionalAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.OptionalValueAssigned;
import org.simantics.databoard.accessor.event.OptionalValueRemoved;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileOptionalAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.OptionalInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.util.binary.Blob;

public class BinaryOptional
extends BinaryObject
implements OptionalAccessor,
FileOptionalAccessor {
    SoftReference<BinaryObject> component;

    public BinaryOptional(BinaryObject parent, Blob blob, OptionalType type, AccessorParams params) throws AccessorConstructionException {
        super(parent, blob, type, params);
    }

    @Override
    public OptionalType type() {
        return (OptionalType)this.type;
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                OptionalBinding ob = (OptionalBinding)binding;
                Object ov = newValue;
                boolean hasValue = ob.hasValue(newValue);
                if (hasValue) {
                    Binding cb = ob.getComponentBinding();
                    Object cv = ob.getValue(ov);
                    this.setComponentValueNoflush(cb, cv);
                } else {
                    this.setNoValueNoflush();
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setComponentValueNoflush(Binding cb, Object cv) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            BinaryObject sa = this.getExistingAccessor();
            if (sa != null) {
                sa.setValue(cb, cv);
                return;
            }
            try {
                Serializer cs = this.params.serializerScheme.getSerializer(cb);
                int size = cs.getSize(cv, null) + 1;
                this.b.setLength(size);
                this.b.position(0L);
                this.b.write(1);
                cs.serialize(this.b, null, cv);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    OptionalInterestSet is = (OptionalInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        MutableVariant newComponentValue = null;
                        if (is.inValues()) {
                            newComponentValue = new MutableVariant(cb, cb.isImmutable() ? cv : cb.clone(cv));
                        }
                        OptionalValueAssigned e = new OptionalValueAssigned(newComponentValue);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setNoValueNoflush() throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.b.position(0L);
                this.b.setLength(1L);
                this.b.write(0);
                BinaryObject sa = this.getExistingAccessor();
                this.component = null;
                if (sa != null) {
                    sa.invalidatedNotification();
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    OptionalInterestSet is = (OptionalInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        OptionalValueRemoved e = new OptionalValueRemoved();
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setNoValue() throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setNoValueNoflush();
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setComponentValue(Binding cb, Object cv) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setComponentValueNoflush(cb, cv);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponentAccessor() throws AccessorConstructionException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            BinaryObject sa = this.getExistingAccessor();
            if (sa != null) {
                BinaryObject binaryObject = sa;
                return (T)binaryObject;
            }
            Datatype ct = this.type().getComponentType();
            sa = this.createSubAccessor(ct, 1L, this.b.length() - 1L, this.params);
            this.component = new SoftReference<BinaryObject>(sa);
            ListenerEntry le = this.listeners;
            while (le != null) {
                OptionalInterestSet is = (OptionalInterestSet)le.getInterestSet();
                InterestSet cis = is.getComponentInterest();
                if (cis != null) {
                    try {
                        ChildReference childPath = ChildReference.concatenate(le.path, new ComponentReference());
                        sa.addListener(le.listener, cis, childPath, le.executor);
                    }
                    catch (AccessorException e) {
                        throw new AccessorConstructionException(e);
                    }
                }
                if (is.getComponentInterest() != null) {
                    sa = (BinaryObject)this.getComponentAccessor();
                    sa.addListener(le.listener, is.getComponentInterest(), null, le.executor);
                }
                le = le.next;
            }
            BinaryObject binaryObject = sa;
            return (T)binaryObject;
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            throw new AccessorConstructionException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    BinaryObject getExistingAccessor() {
        SoftReference<BinaryObject> ref = this.component;
        BinaryObject accessor = ref != null ? ref.get() : null;
        return accessor;
    }

    @Override
    public Object getComponentValue(Binding cb) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(1L);
            Serializer cs = this.params.serializerScheme.getSerializer(cb);
            Object object = cs.deserialize(this.b, null);
            return object;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean hasValue() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            byte v = this.b.readByte();
            if (v == 0) {
                return false;
            }
            if (v == 1) {
                return true;
            }
            try {
                throw new AccessorException("Unexpected value " + v + ", expected 0/1");
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            if (lr.label.equals("o")) {
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
        }
        if (reference instanceof ComponentReference) {
            T result = this.getComponentAccessor();
            if (reference.getChildReference() != null) {
                result = result.getComponent(reference.getChildReference());
            }
            return result;
        }
        throw new ReferenceException(reference.getClass() + " is not a reference of OptionalType");
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        super.addListener(listener, interestSet, path, executor);
        OptionalInterestSet is = (OptionalInterestSet)interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null) {
            return;
        }
        BinaryObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        ChildReference childPath = ChildReference.concatenate(path, new ComponentReference());
        sa.addListener(listener, cis, childPath, executor);
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        OptionalInterestSet is = (OptionalInterestSet)e.interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null) {
            return;
        }
        BinaryObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        sa.removeListener(listener);
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ModificationEvent rollback = null;
        if (makeRollback) {
            if (this.hasValue()) {
                OptionalBinding cb = (OptionalBinding)Bindings.getMutableBinding(this.type().getComponentType());
                Object cv = this.getComponentValue(cb);
                rollback = new OptionalValueAssigned(cb, cv);
            } else {
                rollback = new OptionalValueRemoved();
            }
        }
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        if (e instanceof OptionalValueAssigned) {
            OptionalValueAssigned oa = (OptionalValueAssigned)e;
            if (oa.newValue == null) {
                throw new AccessorException("Cannot apply field assignment event, the value is missing");
            }
            this.setComponentValueNoflush(oa.newValue.getBinding(), oa.newValue.getValue());
        } else if (e instanceof OptionalValueRemoved) {
            this.setNoValueNoflush();
        } else {
            throw new AccessorException("Unexpected event type " + e.getClass().getName() + " for an Optional Type");
        }
        return rollback;
    }
}

