/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard;

import org.simantics.databoard.units.ConverterCreator;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.databoard.units.IdentityConverter;
import org.simantics.databoard.units.internal.UnitParseException;
import org.simantics.databoard.units.internal.library.UnitLibrary;

public class Units {
    public static UnitLibrary library = UnitLibrary.createDefault();

    public static IUnitConverter createConverter(String sourceUnit, String targetUnit) throws UnitParseException {
        if (sourceUnit.equals(targetUnit)) {
            return IdentityConverter.INSTANCE;
        }
        ConverterCreator creator = new ConverterCreator(library);
        creator.unit(sourceUnit, 1);
        creator.unit(targetUnit, -1);
        return creator.createConverter();
    }

    public static double convert(double value, String sourceUnit, String targetUnit) throws UnitParseException {
        IUnitConverter c = Units.createConverter(sourceUnit, targetUnit);
        if (c == null) {
            throw new UnitParseException(String.valueOf(sourceUnit) + " or " + targetUnit, "could not convert");
        }
        return c.convert(value);
    }
}

