/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.maps.server.prefs;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;
import org.simantics.district.maps.server.Activator;

public class MapsServerPreferences {
    public static final String P_NODE = "org.simantics.maps.server";
    public static final String P_START_AUTOMATICALLY = "org.simantics.maps.server.startAutomatically";
    public static final String P_DEFAULT_PORT = "org.simantics.maps.server.defaultPort";
    public static final String P_CURRENT_MBTILES = "org.simantics.maps.server.currentMbTiles";
    public static final String P_CURRENT_TM2STYLE = "org.simantics.maps.server.currentTM2Style";
    public static final String P_SERVER_FOLDER = "org.simantics.maps.server.serverFolder";

    public static Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(P_NODE);
    }

    public static boolean startAutomatically() {
        return MapsServerPreferences.getPreferences().getBoolean(P_START_AUTOMATICALLY, true);
    }

    public static int defaultPort() {
        return MapsServerPreferences.getPreferences().getInt(P_DEFAULT_PORT, 8585);
    }

    public static String currentMBTiles() {
        return MapsServerPreferences.getPreferences().get(P_CURRENT_MBTILES, "helsinki_finland.mbtiles");
    }

    public static String currentTM2Style() {
        return MapsServerPreferences.getPreferences().get(P_CURRENT_TM2STYLE, "mapbox-studio-osm-bright.tm2");
    }

    public static String serverFolder() throws IOException, URISyntaxException {
        return MapsServerPreferences.getPreferences().get(P_SERVER_FOLDER, Activator.getTileserverMapnikRoot().toAbsolutePath().toString());
    }
}

