/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.server.ui.prefs;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.district.maps.server.TileserverMapnik;
import org.simantics.district.maps.server.TileserverMapnikInstance;
import org.simantics.district.network.ui.DynamicComboFieldEditor;
import org.simantics.maps.server.ui.TileserverMapnikStartJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapsServerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapsServerPreferencePage.class);
    private TileserverMapnik server;
    private FileFieldEditor addNew;
    private DynamicComboFieldEditor currentTilesSelector;

    public MapsServerPreferencePage() {
        super(1);
        this.setDescription("Maps server preferences");
    }

    public void init(IWorkbench workbench) {
        try {
            this.server = TileserverMapnikInstance.get();
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Could not initialize " + ((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.maps.server");
    }

    private void createServerStatusField(final Composite parent) {
        final Label label = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        final Button b = new Button(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)b);
        this.updateWidgets(label, b);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (MapsServerPreferencePage.this.server.isRunning()) {
                        MapsServerPreferencePage.this.server.stop();
                        MapsServerPreferencePage.this.updateWidgets(label, b);
                    } else {
                        new TileserverMapnikStartJob(status -> parent.getDisplay().asyncExec(() -> MapsServerPreferencePage.this.updateWidgets(label, b))).schedule();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Could not start/stop server", (Throwable)ex);
                }
            }
        });
    }

    private void updateWidgets(Label label, Button b) {
        String labelText = "";
        String buttonText = "";
        int labelColor = -1;
        try {
            if (this.server.isRunning()) {
                buttonText = "Stop";
                labelText = "running";
                labelColor = 6;
            } else {
                labelText = "stopped";
                buttonText = "Start";
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Could not create server status field!", (Throwable)e);
            labelText = "unknown";
            labelColor = 4;
        }
        label.setText("Tileserver is currently " + labelText);
        label.setForeground(this.getShell().getDisplay().getSystemColor(labelColor));
        b.setText(String.valueOf(buttonText) + " server");
    }

    private void createGeneralGroup() {
        Group serverGroup = new Group(this.getFieldEditorParent(), 0);
        serverGroup.setText("General");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)serverGroup);
        this.createServerStatusField((Composite)serverGroup);
        IntegerFieldEditor port = new IntegerFieldEditor("org.simantics.maps.server.defaultPort", "Tileserver port", (Composite)serverGroup);
        this.addField((FieldEditor)port);
        BooleanFieldEditor automatically = new BooleanFieldEditor("org.simantics.maps.server.startAutomatically", "Start tileserver automatically", (Composite)serverGroup);
        this.addField((FieldEditor)automatically);
        StringFieldEditor serverFolder = new StringFieldEditor("org.simantics.maps.server.serverFolder", "Server folder", (Composite)serverGroup);
        serverFolder.setEnabled(false, (Composite)serverGroup);
        this.addField((FieldEditor)serverFolder);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)serverGroup);
    }

    protected void createFieldEditors() {
        this.createGeneralGroup();
        this.createStylesGroup();
        this.createTilesGroup();
    }

    private void createStylesGroup() {
        Group stylesGroup = new Group(this.getFieldEditorParent(), 0);
        stylesGroup.setText("Styles");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)stylesGroup);
        this.createTM2StylesField((Composite)stylesGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)stylesGroup);
    }

    private void createTM2StylesField(Composite parent) {
        try {
            List styles = this.server.listStyles();
            String[][] namesAndValues = new String[styles.size()][];
            int i = 0;
            while (i < styles.size()) {
                String style = (String)styles.get(i);
                String[] nameAndValue = new String[]{style, style};
                namesAndValues[i] = nameAndValue;
                ++i;
            }
            ComboFieldEditor selector = new ComboFieldEditor("org.simantics.maps.server.currentTM2Style", "Selected Style", namesAndValues, parent);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)selector.getLabelControl(parent));
            this.addField((FieldEditor)selector);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createTilesGroup() {
        Group tilesGroup = new Group(this.getFieldEditorParent(), 0);
        tilesGroup.setText("Vector Tiles");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)tilesGroup);
        this.createTilesField((Composite)tilesGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)tilesGroup);
    }

    private void createTilesField(Composite parent) {
        try {
            String[][] namesAndValues = this.computeNamesAndValues();
            this.currentTilesSelector = new DynamicComboFieldEditor("org.simantics.maps.server.currentMbTiles", "Current Tiles", namesAndValues, parent);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.currentTilesSelector.getLabelControl(parent));
            this.addField((FieldEditor)this.currentTilesSelector);
            Composite newParent = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)newParent);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(newParent);
            this.addNew = new FileFieldEditor("Add new tiles", "Add new tiles", newParent);
            this.addNew.setPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    System.out.println(event);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Could not create tiles field", (Throwable)e);
        }
    }

    private String[][] computeNamesAndValues() throws IOException {
        List tiles = this.server.availableMBTiles();
        String[][] namesAndValues = new String[tiles.size()][];
        int i = 0;
        while (i < tiles.size()) {
            String style = (String)tiles.get(i);
            String[] nameAndValue = new String[]{style, style};
            namesAndValues[i] = nameAndValue;
            ++i;
        }
        return namesAndValues;
    }

    protected void performApply() {
        super.performApply();
        String fileLocation = this.addNew.getStringValue();
        if (fileLocation != null && !fileLocation.isEmpty()) {
            Path p = Paths.get(fileLocation, new String[0]);
            Path target = this.server.getDataDirectory().resolve(p.getFileName());
            try {
                Files.copy(p, target, new CopyOption[0]);
                this.addNew.setStringValue("");
            }
            catch (IOException e) {
                String message = "Could not upload " + fileLocation + " to " + target.toAbsolutePath();
                LOGGER.error(message, (Throwable)e);
                this.setErrorMessage(message);
            }
        }
        try {
            this.currentTilesSelector.updateCombo(this.computeNamesAndValues());
            this.currentTilesSelector.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean performOk() {
        boolean success = super.performOk();
        try {
            this.server.stop();
            new TileserverMapnikStartJob(status -> {}).schedule();
        }
        catch (Exception e) {
            LOGGER.error("Could not restart tileserver-mapnik", (Throwable)e);
        }
        return success;
    }
}

