/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.server.ui;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.district.maps.server.TileserverMapnik;
import org.simantics.district.maps.server.TileserverMapnikInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileserverMapnikStartJob
extends Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(TileserverMapnikStartJob.class);
    private Consumer<IStatus> callback;

    public TileserverMapnikStartJob(Consumer<IStatus> callback) {
        super("Tileserver start job");
        this.callback = callback;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Starting tileserver", 100);
        IStatus status = Status.OK_STATUS;
        try {
            StartListener startListener = new StartListener(monitor);
            TileserverMapnikInstance.get().start(Optional.of(startListener));
            if (startListener.module != null || startListener.returnValue != 0) {
                status = new Status(4, "org.simantics.maps.server.ui", "Could not install " + String.valueOf(startListener.module) + " with returnValue " + startListener.returnValue);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not start tileserver-mapnik", (Throwable)e);
            status = new Status(4, "org.simantics.maps.server.ui", "Could not start tileserver-mapnik: " + e.getMessage());
        }
        this.callback.accept(status);
        return status;
    }

    private class StartListener
    implements TileserverMapnik.TileserverStartListener {
        private IProgressMonitor monitor;
        private String module;
        private int returnValue;

        public StartListener(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void installing(String module) {
            StringBuilder sb = new StringBuilder();
            sb.append("Installing module ");
            if (module == null) {
                module = "tileserver-mapnik";
            }
            sb.append(module);
            this.monitor.subTask(sb.toString());
            this.monitor.worked(30);
        }

        public void installationFailed(String module, int returnValue) {
            this.module = module;
            this.returnValue = returnValue;
            LOGGER.warn("Installation of module {} failed with returnValue ", (Object)String.valueOf(module), (Object)returnValue);
        }

        public void started() {
            this.monitor.subTask("Finished");
            this.monitor.worked(10);
            this.monitor.done();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Tileserver started succesfully");
            }
        }
    }
}

