/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.region.ontology.DiagramRegionsResource;
import org.simantics.district.route.ontology.RouteResource;
import org.simantics.district.selection.ElementSelectionResource;
import org.simantics.district.selection.ElementSelectionUtils;
import org.simantics.district.selection.ElementSelector;
import org.simantics.district.selection.ui.ElementSelectionTools;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.workbench.dialogs.ColorDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSelectorDialog
extends Dialog {
    private static final RowLayoutFactory ROW_LAYOUT = RowLayoutFactory.fillDefaults().wrap(false);
    private static final ImageDescriptor CROSS_IMAGE = (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"com.famfamfam.silk", (String)"icons/cross.png").get();
    private static final ImageDescriptor PLUS_IMAGE = (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"com.famfamfam.silk", (String)"icons/add.png").get();
    private static Logger LOGGER = LoggerFactory.getLogger(EditSelectorDialog.class);
    private ElementSelector elementSelector;
    Collection<Resource> currentSelection;
    private List<Resource> diagrams;
    private ArrayList<String> diagramNames;
    private String[] regionNames;
    private Resource[] regionResources;
    private String[] routeNames;
    private Resource[] routeResources;
    private List<Resource> componentTypes;
    private List<String> componentTypeNames;
    private List<String> propertyNames;
    private List<String> propertyLabels;
    private Composite conditionPanel;
    private int generatorIndex;
    private Combo sourceField;
    private String name;
    private Text nameField;
    private Color color;
    private TableCombo colorCombo;
    private Resource diagram;
    private Combo diagramField;
    private int selectorIndex;
    private Combo selectorField;
    private Resource componentType;
    private Combo componentTypeField;
    private String propertyName;
    private Combo propertyField;
    private int numberOfItems;
    private Text nField;
    private ElementSelector.Condition condition;
    private Composite content;
    private int diagramIndex;
    private LocalResourceManager resourceManager;
    static final Updater NULL_UPDATE = validate -> {};
    Updater updater = NULL_UPDATE;

    @Inject
    public EditSelectorDialog(Shell shell, final ElementSelector elementSelector, Collection<Resource> currentSelection) {
        super(shell);
        this.elementSelector = elementSelector;
        if (elementSelector != null) {
            try {
                Simantics.getSession().sync((ReadInterface)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        elementSelector.buildSelection(graph);
                    }
                });
            }
            catch (DatabaseException e1) {
                LOGGER.error("Failed to read element selector resource " + elementSelector.getResource(), (Throwable)e1);
                throw new RuntimeDatabaseException((Throwable)e1);
            }
        }
        this.currentSelection = currentSelection;
        Map diagramMap = ElementSelector.findDiagrams();
        this.diagrams = new ArrayList<Resource>(diagramMap.size());
        this.diagramNames = new ArrayList(diagramMap.size());
        diagramMap.entrySet().stream().sorted(Comparator.comparing(e -> (String)e.getValue())).forEachOrdered(e -> {
            this.diagrams.add((Resource)e.getKey());
            this.diagramNames.add((String)e.getValue());
        });
        this.name = elementSelector != null ? elementSelector.getName() : "";
        this.propertyName = "";
        this.numberOfItems = 1;
        this.generatorIndex = 0;
        this.selectorIndex = 0;
        this.diagram = null;
        this.condition = null;
        if (elementSelector != null) {
            ElementSelector.Generator generator;
            float[] color = elementSelector.getColor();
            if (color != null) {
                this.color = ElementSelectionTools.literalToColor(color);
            }
            if ((generator = elementSelector.getGenerator()) instanceof ElementSelector.ModelGenerator) {
                this.generatorIndex = 0;
            } else if (generator instanceof ElementSelector.DiagramGenerator) {
                this.generatorIndex = 1;
                this.diagram = ((ElementSelector.DiagramGenerator)generator).diagram;
            } else if (generator instanceof ElementSelector.ExplicitGenerator) {
                this.generatorIndex = 2;
            } else {
                throw new IllegalStateException("Unknown generator type " + generator.getClass().getName());
            }
            ElementSelector.Selector selector = elementSelector.getSelector();
            if (selector instanceof ElementSelector.All) {
                this.selectorIndex = 0;
            } else if (selector instanceof ElementSelector.PropertySelector) {
                ElementSelector.PropertySelector propertySelector = (ElementSelector.PropertySelector)selector;
                this.selectorIndex = propertySelector.smallest ? 1 : 2;
                this.propertyName = propertySelector.propertyName;
                this.numberOfItems = propertySelector.resultCount;
            } else {
                throw new IllegalStateException("Unknwon selector type " + selector.getClass().getName());
            }
            this.condition = elementSelector.getCondition();
            this.componentType = elementSelector.getSelector().componentType;
        }
        this.readRegions(this.diagram);
        this.readRoutes();
        this.readComponentTypes();
        this.updatePropertyList();
    }

    private void readComponentTypes() {
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    List<Resource> types = EditSelectorDialog.findComponentTypes(graph);
                    EditSelectorDialog.this.componentTypes = new ArrayList<Resource>(types.size() + 1);
                    EditSelectorDialog.this.componentTypeNames = new ArrayList<String>(types.size() + 1);
                    EditSelectorDialog.this.componentTypes.add(null);
                    EditSelectorDialog.this.componentTypeNames.add("Any type");
                    EditSelectorDialog.this.componentTypes.addAll(types);
                    for (Resource t : types) {
                        EditSelectorDialog.this.componentTypeNames.add((String)graph.getValue2(t, (Object)L0.HasName));
                    }
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read district component types", (Throwable)e);
        }
    }

    private void readRoutes() {
        final HashMap routes = new HashMap();
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    RouteResource ROUTE = RouteResource.getInstance((ReadGraph)graph);
                    Resource model = ActiveModels.getPossibleActiveModel((ReadGraph)graph, (Resource)Simantics.getProjectResource());
                    List routeCollection = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)ROUTE.Route);
                    for (Resource r : routeCollection) {
                        String name = (String)graph.getRelatedValue(r, L0.HasLabel);
                        routes.put(r, name);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read routes in the model", (Throwable)e);
        }
        this.routeNames = routes.values().toArray(new String[routes.size()]);
        this.routeResources = routes.keySet().toArray(new Resource[routes.size()]);
    }

    private void readRegions(final Resource diagram) {
        final HashMap regions = new HashMap();
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    DiagramRegionsResource DR = DiagramRegionsResource.getInstance((ReadGraph)graph);
                    Collection<Resource> ds = diagram != null ? Collections.singleton(diagram) : EditSelectorDialog.this.diagrams;
                    for (Resource composite : ds) {
                        Resource diagram2 = graph.getSingleObject(composite, MOD.CompositeToDiagram);
                        for (Resource r : graph.getObjects(diagram2, DR.hasRegion)) {
                            if (!graph.isInstanceOf(r, DR.Region)) continue;
                            String name = (String)graph.getRelatedValue(r, L0.HasLabel);
                            regions.put(r, name);
                        }
                    }
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read regions in the model", (Throwable)e);
        }
        this.regionNames = regions.values().toArray(new String[regions.size()]);
        this.regionResources = regions.keySet().toArray(new Resource[regions.size()]);
    }

    private void updateDialog() {
        block2: {
            try {
                this.updater.update(false);
            }
            catch (ValidationException validationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.updater = this.updateConditionPanel();
        this.content.layout(true, true);
        this.getShell().pack();
    }

    protected void okPressed() {
        try {
            this.generatorIndex = this.sourceField.getSelectionIndex();
            if (this.generatorIndex == 1) {
                int selectionIndex = this.diagramField.getSelectionIndex();
                if (selectionIndex < 0) {
                    this.diagramField.setFocus();
                    throw new ValidationException("Please select a diagram");
                }
                this.diagram = this.diagrams.get(selectionIndex);
            }
            this.name = this.nameField.getText();
            if (this.name.isEmpty()) {
                this.nameField.setFocus();
                throw new ValidationException("Please enter a name");
            }
            int index = this.colorCombo.getSelectionIndex();
            if (index >= 0) {
                this.color = new Color(this.colorCombo.getTable().getItem(index).getBackground().getRGB());
            }
            this.componentType = this.componentTypes.get(this.componentTypeField.getSelectionIndex());
            this.selectorIndex = this.selectorField.getSelectionIndex();
            if (this.selectorIndex != 0) {
                int propertyIndex = this.propertyField.getSelectionIndex();
                String string = this.propertyName = propertyIndex >= 0 ? this.propertyNames.get(propertyIndex) : this.propertyField.getText();
                if (this.propertyName.isEmpty()) {
                    this.propertyField.setFocus();
                    throw new ValidationException("Please select a property");
                }
            }
            if (this.useNumberOfItems()) {
                try {
                    this.numberOfItems = Integer.parseInt(this.nField.getText());
                    if (this.numberOfItems <= 0) {
                        this.nField.selectAll();
                        this.nField.setFocus();
                        throw new ValidationException("Number of elements must be positive");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.nField.selectAll();
                    this.nField.setFocus();
                    throw new ValidationException("Please enter a valid number of elements");
                }
            }
            this.updater.update(true);
        }
        catch (ValidationException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Missing data", (String)e.getMessage());
            return;
        }
        super.okPressed();
    }

    public void writeSelection() throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource selectorType;
                Resource generatorType;
                Resource selection;
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                graph.markUndoPoint();
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Created new element selection");
                Resource lib = ElementSelectionUtils.ensureSelectionLibrary((RequestProcessor)graph);
                if (EditSelectorDialog.this.elementSelector != null) {
                    selection = EditSelectorDialog.this.elementSelector.getResource();
                    graph.deny(selection);
                } else {
                    selection = graph.newResource();
                }
                graph.claim(selection, L0.InstanceOf, ES.Selection);
                graph.claimLiteral(selection, L0.HasName, L0.String, (Object)UUID.randomUUID().toString());
                graph.claimLiteral(selection, L0.HasLabel, L0.String, (Object)EditSelectorDialog.this.name);
                graph.claim(selection, L0.PartOf, lib);
                if (EditSelectorDialog.this.color != null) {
                    float[] value = ElementSelectionTools.colorToLiteral(EditSelectorDialog.this.color);
                    graph.claimLiteral(selection, ES.Selection_HasHighlightColor, G2DResource.getInstance((ReadGraph)graph).Color, (Object)value, (Binding)Bindings.FLOAT_ARRAY);
                }
                Resource generator = graph.newResource();
                switch (EditSelectorDialog.this.generatorIndex) {
                    case 0: {
                        generatorType = ES.Generator_Model;
                        break;
                    }
                    case 1: {
                        generatorType = ES.Generator_Diagram;
                        Resource composite = graph.getPossibleObject(EditSelectorDialog.this.diagram, MOD.DiagramToComposite);
                        graph.claim(generator, ES.Generator_HasDiagram, composite != null ? composite : EditSelectorDialog.this.diagram);
                        break;
                    }
                    case 2: {
                        generatorType = ES.Generator_Explicit;
                        for (Resource r : EditSelectorDialog.this.currentSelection) {
                            if (graph.isInstanceOf(r, DIA.Connection) || !graph.isInstanceOf(r, DIA.Element) && (!graph.hasStatement(r, MOD.ComponentToElement) || (r = graph.getPossibleObject(r, MOD.ComponentToElement)) == null)) continue;
                            graph.claim(generator, ES.Generator_HasSelectedElement, r);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid source index " + EditSelectorDialog.this.generatorIndex);
                    }
                }
                graph.claim(generator, L0.InstanceOf, generatorType);
                graph.claim(selection, ES.Selection_HasGenerator, generator);
                Resource selector = graph.newResource();
                switch (EditSelectorDialog.this.selectorIndex) {
                    case 0: {
                        selectorType = ES.Selector_All;
                        break;
                    }
                    case 1: {
                        selectorType = ES.Selector_NLowest;
                        break;
                    }
                    case 2: {
                        selectorType = ES.Selector_NHighest;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid selector index " + EditSelectorDialog.this.selectorIndex);
                    }
                }
                graph.claim(selector, L0.InstanceOf, selectorType);
                graph.claim(selection, ES.Selection_HasSelector, selector);
                graph.deny(selector, ES.Selector_HasMapping);
                if (EditSelectorDialog.this.componentType != null) {
                    graph.claim(selector, ES.Selector_HasMapping, EditSelectorDialog.this.componentType);
                }
                if (EditSelectorDialog.this.selectorIndex > 0) {
                    graph.claimLiteral(selector, ES.PropertySelector_HasSelectionPropertyName, L0.String, (Object)EditSelectorDialog.this.propertyName);
                    graph.claimLiteral(selector, ES.PropertySelector_HasResultCount, L0.Integer, (Object)EditSelectorDialog.this.numberOfItems);
                }
                if (EditSelectorDialog.this.condition != null) {
                    Resource conditionResource = EditSelectorDialog.this.condition.update(graph);
                    graph.claim(selection, ES.Selection_HasCondition, conditionResource);
                }
            }
        });
    }

    private boolean isDiagramFieldVisible() {
        return this.generatorIndex == 1;
    }

    private boolean useNumberOfItems() {
        return this.selectorIndex != 0;
    }

    protected Control createDialogArea(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.getShell().setText("Edit element selector");
        this.content = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.content);
        Label nameLabel = new Label(this.content, 0);
        nameLabel.setText("Name");
        GridDataFactory.swtDefaults().applyTo((Control)nameLabel);
        this.nameField = new Text(this.content, 2048);
        this.nameField.setEditable(true);
        this.nameField.setText(this.name);
        GridDataFactory.swtDefaults().hint(200, -1).applyTo((Control)this.nameField);
        Label label = new Label(this.content, 0);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        label.setText("Highlight color");
        this.colorCombo = new TableCombo(this.content, 2056);
        GridDataFactory.swtDefaults().hint(80, -1).applyTo((Control)this.colorCombo);
        final Table colorTable = this.colorCombo.getTable();
        this.colorCombo.getTextControl().setEnabled(false);
        Display display = this.getShell().getDisplay();
        colorTable.setFont(display.getSystemFont());
        this.createColorItem(colorTable, "Red", 3);
        this.createColorItem(colorTable, "Green", 5);
        this.createColorItem(colorTable, "Blue", 9);
        this.createColorItem(colorTable, "Yellow", 7);
        this.createColorItem(colorTable, "Cyan", 13);
        this.createColorItem(colorTable, "Magenta", 11);
        final TableItem other = new TableItem(colorTable, 0);
        other.setText("Other...");
        if (this.color != null) {
            int i = 0;
            while (i < 6) {
                if (colorTable.getItem(i).getBackground().getRGB().equals((Object)this.color.getRgb())) {
                    this.colorCombo.select(i);
                    break;
                }
                ++i;
            }
            if (i == 6) {
                other.setBackground(this.resourceManager.createColor(this.color.getRgb()));
                this.colorCombo.select(6);
            }
        }
        this.colorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog;
                int result;
                int index = EditSelectorDialog.this.colorCombo.getSelectionIndex();
                if (index == 6 && (result = (colorDialog = new ColorDialog(EditSelectorDialog.this.getParentShell())).open()) == 0) {
                    other.setBackground(EditSelectorDialog.this.resourceManager.createColor(colorDialog.getColor().getRgb()));
                    EditSelectorDialog.this.colorCombo.clearSelection();
                    EditSelectorDialog.this.colorCombo.select(6);
                    colorTable.redraw();
                }
            }
        });
        Label selectorLabel = new Label(this.content, 0);
        selectorLabel.setText("Select");
        GridDataFactory.swtDefaults().applyTo((Control)selectorLabel);
        Composite selectorComposite = new Composite(this.content, 0);
        GridDataFactory.swtDefaults().applyTo((Control)selectorComposite);
        RowLayoutFactory.fillDefaults().applyTo(selectorComposite);
        this.nField = new Text(selectorComposite, 2048);
        RowDataFactory.swtDefaults().hint(40, -1).applyTo((Control)this.nField);
        if (this.useNumberOfItems()) {
            this.nField.setText(Integer.toString(this.numberOfItems));
        }
        this.nField.setEnabled(this.useNumberOfItems());
        this.componentTypeField = new Combo(selectorComposite, 8);
        RowDataFactory.swtDefaults().applyTo((Control)this.componentTypeField);
        this.componentTypeField.setItems(this.componentTypeNames.toArray(new String[0]));
        int index = this.componentTypes.indexOf(this.componentType);
        this.componentTypeField.select(index >= 0 ? index : 0);
        this.componentTypeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = EditSelectorDialog.this.componentTypeField.getSelectionIndex();
                EditSelectorDialog.this.componentType = index >= 0 ? EditSelectorDialog.this.componentTypes.get(index) : null;
                EditSelectorDialog.this.updatePropertyList();
                EditSelectorDialog.this.propertyField.setItems(EditSelectorDialog.this.propertyLabels.toArray(new String[0]));
                EditSelectorDialog.this.updateDialog();
            }
        });
        new Label(selectorComposite, 0).setText("with");
        this.selectorField = new Combo(selectorComposite, 2056);
        this.selectorField.setItems(new String[]{"All", "Lowest", "Highest"});
        this.selectorField.select(this.selectorIndex);
        RowDataFactory.swtDefaults().hint(40, -1).applyTo((Control)this.selectorField);
        this.propertyField = new Combo(selectorComposite, 0);
        RowDataFactory.swtDefaults().hint(120, -1).applyTo((Control)this.propertyField);
        this.propertyField.setItems(this.propertyLabels.toArray(new String[0]));
        int n = index = this.propertyName != null ? this.propertyNames.indexOf(this.propertyName) : -1;
        if (index >= 0) {
            this.propertyField.select(index);
        } else {
            this.propertyField.setText(this.propertyName != null ? this.propertyName : "");
        }
        this.propertyField.setEnabled(this.useNumberOfItems());
        this.selectorField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditSelectorDialog.this.selectorIndex = EditSelectorDialog.this.selectorField.getSelectionIndex();
                boolean enable = EditSelectorDialog.this.useNumberOfItems();
                EditSelectorDialog.this.nField.setEnabled(enable);
                EditSelectorDialog.this.propertyField.setEnabled(enable);
                EditSelectorDialog.this.nField.setText(enable ? Integer.toString(EditSelectorDialog.this.numberOfItems) : "");
            }
        });
        Label sourceLabel = new Label(this.content, 0);
        sourceLabel.setText("from");
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)sourceLabel);
        Composite sourceComposite = new Composite(this.content, 0);
        GridDataFactory.swtDefaults().applyTo((Control)sourceComposite);
        RowLayoutFactory.fillDefaults().applyTo(sourceComposite);
        this.sourceField = new Combo(sourceComposite, 2056);
        RowDataFactory.swtDefaults().applyTo((Control)this.sourceField);
        this.sourceField.setItems(new String[]{"Whole model", "Diagram", "Current selection"});
        this.sourceField.select(this.generatorIndex);
        this.diagramField = new Combo(sourceComposite, 2056);
        RowDataFactory.swtDefaults().hint(120, -1).applyTo((Control)this.diagramField);
        this.diagramField.setItems(this.diagramNames.toArray(new String[this.diagramNames.size()]));
        this.diagramField.setEnabled(this.isDiagramFieldVisible());
        this.diagramIndex = this.diagram != null ? this.diagrams.indexOf(this.diagram) : -1;
        this.diagramField.select(this.diagramIndex);
        this.sourceField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditSelectorDialog.this.generatorIndex = EditSelectorDialog.this.sourceField.getSelectionIndex();
                boolean enabled = EditSelectorDialog.this.isDiagramFieldVisible();
                if (!enabled) {
                    EditSelectorDialog.this.diagramIndex = EditSelectorDialog.this.diagramField.getSelectionIndex();
                    EditSelectorDialog.this.diagramField.clearSelection();
                } else if (EditSelectorDialog.this.diagramIndex >= 0) {
                    EditSelectorDialog.this.diagramField.select(EditSelectorDialog.this.diagramIndex);
                } else {
                    EditSelectorDialog.this.diagramField.clearSelection();
                }
                EditSelectorDialog.this.diagramField.setEnabled(enabled);
                EditSelectorDialog.this.diagram = enabled ? (EditSelectorDialog.this.diagramIndex >= 0 ? EditSelectorDialog.this.diagrams.get(EditSelectorDialog.this.diagramIndex) : null) : null;
                EditSelectorDialog.this.readRegions(EditSelectorDialog.this.diagram);
                EditSelectorDialog.this.updateDialog();
            }
        });
        this.sourceField.select(this.generatorIndex);
        label = new Label(this.content, 0);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)label);
        label.setText("where");
        this.conditionPanel = new Composite(this.content, 0);
        GridDataFactory.swtDefaults().minSize(400, -1).grab(true, false).applyTo((Control)this.conditionPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.conditionPanel);
        this.updater = this.updateConditionPanel();
        return this.content;
    }

    private TableItem createColorItem(Table colorTable, String name, int color) {
        TableItem item = new TableItem(colorTable, 2048);
        item.setText(name);
        item.setBackground(colorTable.getDisplay().getSystemColor(color));
        return item;
    }

    private Updater updateConditionPanel() {
        Control[] controlArray = this.conditionPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        return this.createConditionPanelFor(this.conditionPanel, this.condition, cond -> {
            ElementSelector.Condition condition = this.condition = cond;
        });
    }

    private Updater createConditionPanelFor(Composite parent, ElementSelector.Condition condition, Consumer<ElementSelector.Condition> consumer) {
        Updater updater;
        Button notCheck = new Button(parent, 32);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)notCheck);
        notCheck.setText("not");
        notCheck.setSelection(condition != null && condition.isInverse);
        Composite conditionComp = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)conditionComp);
        Combo typeCombo = new Combo(conditionComp, 2056);
        typeCombo.setItems(new String[]{"No condition", "Property", "In region", "On route", "All of", "Any of"});
        typeCombo.addSelectionListener((SelectionListener)new ConditionTypeSelectionListener(typeCombo, consumer, condition));
        if (condition instanceof ElementSelector.PropertyCondition) {
            typeCombo.select(1);
            updater = this.createPropertyConditionPanel(conditionComp, (ElementSelector.PropertyCondition)condition);
        } else if (condition instanceof ElementSelector.RegionCondition) {
            typeCombo.select(2);
            updater = this.createRegionConditionPanel(conditionComp, (ElementSelector.RegionCondition)condition);
        } else if (condition instanceof ElementSelector.RouteCondition) {
            typeCombo.select(3);
            updater = this.createRouteConditionPanel(conditionComp, (ElementSelector.RouteCondition)condition);
        } else if (condition instanceof ElementSelector.AggregateCondition) {
            ElementSelector.AggregateCondition cond = (ElementSelector.AggregateCondition)condition;
            typeCombo.select(cond.type.equals((Object)ElementSelector.AggregateCondition.Type.CONJUNCTION) ? 4 : 5);
            updater = this.createAggregateConditionPanel(conditionComp, cond);
        } else {
            ROW_LAYOUT.applyTo(conditionComp);
            notCheck.setEnabled(false);
            typeCombo.select(0);
            return NULL_UPDATE;
        }
        return validate -> {
            updater.update(validate);
            condition.isInverse = notCheck.getSelection();
        };
    }

    private Updater createAggregateConditionPanel(Composite conditionComp, final ElementSelector.AggregateCondition cond) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(conditionComp);
        new Label(conditionComp, 0);
        int n = cond.conditions.size();
        Updater[] updates = new Updater[n];
        int i = 0;
        while (i < n) {
            updates[i] = this.createConditionRowPanel(conditionComp, cond, i);
            ++i;
        }
        Button addButton = new Button(conditionComp, 8);
        GridDataFactory.swtDefaults().applyTo((Control)addButton);
        addButton.setImage(this.resourceManager.createImage(PLUS_IMAGE));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cond.conditions.add(EditSelectorDialog.createPropertyCondition("", null, null));
                EditSelectorDialog.this.updateDialog();
            }
        });
        return validate -> {
            Updater[] updaterArray2 = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                Updater updater = updaterArray2[n2];
                updater.update(validate);
                ++n2;
            }
        };
    }

    private Updater createConditionRowPanel(Composite parent, final ElementSelector.AggregateCondition parentCondition, final int i) {
        GridLayoutFactory conditionLayout = GridLayoutFactory.fillDefaults().numColumns(2);
        GridDataFactory swtDefaults = GridDataFactory.swtDefaults();
        ElementSelector.Condition c = (ElementSelector.Condition)parentCondition.conditions.get(i);
        Composite row = new Composite(parent, 0);
        conditionLayout.applyTo(row);
        swtDefaults.applyTo((Control)row);
        Consumer<ElementSelector.Condition> update = cd -> {
            if (cd != null) {
                aggregateCondition.conditions.set(i, cd);
            } else {
                aggregateCondition.conditions.remove(i);
            }
        };
        Updater updater = this.createConditionPanelFor(row, c, update);
        Button removeButton = new Button(parent, 8);
        swtDefaults.align(1, 1).applyTo((Control)removeButton);
        removeButton.setImage(this.resourceManager.createImage(CROSS_IMAGE));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parentCondition.conditions.remove(i);
                EditSelectorDialog.this.updateDialog();
            }
        });
        return updater;
    }

    private Updater createRouteConditionPanel(Composite conditionComp, ElementSelector.RouteCondition condition) {
        ROW_LAYOUT.applyTo(conditionComp);
        Combo routeCombo = new Combo(conditionComp, 8);
        RowDataFactory.swtDefaults().hint(120, -1).applyTo((Control)routeCombo);
        routeCombo.setItems(this.routeNames);
        int index = Arrays.indexOf((Object[])this.routeResources, (Object)condition.routeResource);
        if (index >= 0) {
            routeCombo.select(index);
        }
        return validate -> {
            int i = routeCombo.getSelectionIndex();
            if (validate && i < 0) {
                routeCombo.forceFocus();
                throw new RuntimeException("Must select a route");
            }
            routeCondition.routeResource = i >= 0 ? this.routeResources[i] : null;
        };
    }

    private Updater createRegionConditionPanel(Composite conditionComp, ElementSelector.RegionCondition condition) {
        ROW_LAYOUT.applyTo(conditionComp);
        Combo regionCombo = new Combo(conditionComp, 8);
        RowDataFactory.swtDefaults().hint(120, -1).applyTo((Control)regionCombo);
        regionCombo.setItems(this.regionNames);
        int index = Arrays.indexOf((Object[])this.regionResources, (Object)condition.regionResource);
        if (index >= 0) {
            regionCombo.select(index);
        }
        return validate -> {
            int i = regionCombo.getSelectionIndex();
            if (validate && i < 0) {
                regionCombo.forceFocus();
                throw new ValidationException("Please select a region");
            }
            regionCondition.regionResource = i >= 0 ? this.regionResources[i] : null;
        };
    }

    private Updater createPropertyConditionPanel(Composite conditionComp, ElementSelector.PropertyCondition condition) {
        ROW_LAYOUT.applyTo(conditionComp);
        Text lowerLimitText = new Text(conditionComp, 2048);
        RowDataFactory.swtDefaults().hint(40, -1).applyTo((Control)lowerLimitText);
        lowerLimitText.setText(condition.lowerLimit != null ? Double.toString(condition.lowerLimit) : "");
        new Label(conditionComp, 0).setText("\u2264");
        Combo propertyNameText = new Combo(conditionComp, 0);
        RowDataFactory.swtDefaults().hint(120, -1).applyTo((Control)propertyNameText);
        propertyNameText.setItems(this.propertyLabels.toArray(new String[0]));
        int index = this.propertyNames.indexOf(condition.propertyName);
        if (index >= 0) {
            propertyNameText.select(index);
        } else {
            propertyNameText.setText(condition.propertyName);
        }
        new Label(conditionComp, 0).setText("\u2264");
        Text upperLimitText = new Text(conditionComp, 2048);
        RowDataFactory.swtDefaults().hint(40, -1).applyTo((Control)upperLimitText);
        upperLimitText.setText(condition.upperLimit != null ? Double.toString(condition.upperLimit) : "");
        return validate -> {
            block6: {
                String text3;
                block5: {
                    try {
                        text3 = lowerLimitText.getText();
                        propertyCondition.lowerLimit = text3.isEmpty() ? null : Double.valueOf(Double.parseDouble(text3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!validate) break block5;
                        lowerLimitText.selectAll();
                        lowerLimitText.forceFocus();
                        throw new ValidationException("Please enter a valid lower limit");
                    }
                }
                try {
                    text3 = upperLimitText.getText();
                    propertyCondition.upperLimit = text3.isEmpty() ? null : Double.valueOf(Double.parseDouble(text3));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!validate) break block6;
                    upperLimitText.selectAll();
                    upperLimitText.forceFocus();
                    throw new ValidationException("Please enter a valid upper limit");
                }
            }
            int ind = propertyNameText.getSelectionIndex();
            String name = ind >= 0 ? this.propertyNames.get(ind) : propertyNameText.getText();
            if (validate && name.isEmpty()) {
                propertyNameText.forceFocus();
                throw new ValidationException("Please select a property");
            }
            propertyCondition.propertyName = name;
        };
    }

    private static ElementSelector.Condition createPropertyCondition(String propertyName, Double lowerLimit, Double upperLimit) {
        return new ElementSelector.PropertyCondition(null, propertyName, lowerLimit, upperLimit);
    }

    private static ElementSelector.Condition createRegionCondition(Resource regionResource) {
        return new ElementSelector.RegionCondition(null, regionResource, null);
    }

    private static ElementSelector.Condition createRouteCondition(Resource route) {
        return new ElementSelector.RouteCondition(null, route, null);
    }

    private static ElementSelector.Condition createAggregateCondition(Resource existingResource, List<ElementSelector.Condition> subConditions, boolean isConjunction, boolean isInverse) {
        ElementSelector.AggregateCondition.Type type = isConjunction ? ElementSelector.AggregateCondition.Type.CONJUNCTION : ElementSelector.AggregateCondition.Type.DISJUNCTION;
        ElementSelector.AggregateCondition condition = new ElementSelector.AggregateCondition(null, type, subConditions);
        condition.isInverse = isInverse;
        return condition;
    }

    static List<Resource> findComponentTypes(ReadGraph graph) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource project = Simantics.getProjectResource();
        Resource model = ActiveModels.getPossibleActiveModel((ReadGraph)graph, (Resource)project);
        return QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)DN.Mapping_Base);
    }

    void updatePropertyList() {
        this.propertyNames = new ArrayList<String>();
        this.propertyLabels = new ArrayList<String>();
        final Collection<Resource> types = this.componentType != null ? Collections.singleton(this.componentType) : this.componentTypes;
        final HashSet properties = new HashSet();
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    for (Resource type : types) {
                        String name;
                        Resource indexRoot;
                        Resource ct;
                        if (type == null || (ct = graph.getPossibleObject(type, DistrictNetworkResource.getInstance((ReadGraph)graph).Mapping_ComponentType)) == null || graph.isInstanceOf(ct, L0.String) && (ct = GraphUtils.getPossibleChild((ReadGraph)graph, (Resource)(indexRoot = (Resource)graph.syncRequest((Read)new IndexRoot(type))), (String)(name = (String)graph.getValue(ct)))) == null) continue;
                        for (Resource prop : graph.getObjects(ct, L0.DomainOf)) {
                            PropertyInfo info;
                            if (!graph.isInstanceOf(prop, StructuralResource2.getInstance((ReadGraph)graph).Property) || (info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(prop))) != null && info.requiredValueType != null && !EditSelectorDialog.isNumericValueType(info.requiredValueType)) continue;
                            String name2 = (String)graph.getRelatedValue2(prop, L0.HasName);
                            String label = (String)graph.getPossibleRelatedValue2(prop, L0.HasLabel);
                            if (label == null) {
                                label = name2;
                            }
                            properties.add(Pair.make((Object)label, (Object)name2));
                        }
                    }
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read district component properties", (Throwable)e);
        }
        this.propertyNames.clear();
        this.propertyLabels.clear();
        properties.stream().sorted(Comparator.comparing(p -> (String)p.first)).forEachOrdered(p -> {
            this.propertyLabels.add((String)p.first);
            this.propertyNames.add((String)p.second);
        });
    }

    static boolean isNumericValueType(String requiredValueType) {
        switch (requiredValueType) {
            case "Integer": 
            case "Long": 
            case "Float": 
            case "Double": {
                return true;
            }
        }
        return false;
    }

    private final class ConditionTypeSelectionListener
    extends SelectionAdapter {
        private final Combo typeCombo;
        private final Consumer<ElementSelector.Condition> consumer;
        private final ElementSelector.Condition finalCondition;

        private ConditionTypeSelectionListener(Combo typeCombo, Consumer<ElementSelector.Condition> consumer, ElementSelector.Condition finalCondition) {
            this.typeCombo = typeCombo;
            this.consumer = consumer;
            this.finalCondition = finalCondition;
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.typeCombo.getSelectionIndex();
            ElementSelector.Condition newCondition = this.finalCondition;
            switch (index) {
                case 0: {
                    newCondition = null;
                    break;
                }
                case 1: {
                    newCondition = EditSelectorDialog.createPropertyCondition("", null, null);
                    break;
                }
                case 2: {
                    newCondition = EditSelectorDialog.createRegionCondition(null);
                    break;
                }
                case 3: {
                    newCondition = EditSelectorDialog.createRouteCondition(null);
                    break;
                }
                case 4: {
                    if (newCondition instanceof ElementSelector.AggregateCondition) {
                        ((ElementSelector.AggregateCondition)newCondition).type = ElementSelector.AggregateCondition.Type.CONJUNCTION;
                        break;
                    }
                    newCondition = EditSelectorDialog.createAggregateCondition(null, new ArrayList<ElementSelector.Condition>(), true, false);
                    break;
                }
                case 5: {
                    if (newCondition instanceof ElementSelector.AggregateCondition) {
                        ((ElementSelector.AggregateCondition)newCondition).type = ElementSelector.AggregateCondition.Type.DISJUNCTION;
                        break;
                    }
                    newCondition = EditSelectorDialog.createAggregateCondition(null, new ArrayList<ElementSelector.Condition>(), false, false);
                }
            }
            this.consumer.accept(newCondition);
            EditSelectorDialog.this.updateDialog();
        }
    }

    static interface Updater {
        public void update(boolean var1) throws ValidationException;
    }

    static class ValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ValidationException(String message) {
            super(message);
        }
    }
}

