/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui;

import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.SyncListenerAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.district.selection.ElementSelector;
import org.simantics.district.selection.ui.ElementSelectionTools;
import org.simantics.district.selection.ui.parts.ElementSelectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSelectorTableUI
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementSelectorTableUI.class);
    private CheckboxTableViewer viewer;
    private ElementSelectionView view;
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);

    public ElementSelectorTableUI(Composite parent, int style, ElementSelectionView view) {
        super(parent, style);
        this.view = view;
        parent.setLayout((Layout)new FillLayout());
        this.setLayout((Layout)new FillLayout());
        this.viewer = this.createViewer();
        this.addSelectionListener();
        this.addCheckStateListener();
        this.setContentProvider();
        this.createSelectorListener(parent);
        this.enableToolTips();
        this.configureTable();
    }

    private void addCheckStateListener() {
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                if (checked) {
                    ElementSelectorTableUI.this.view.performSelection(ElementSelectorTableUI.this.getDisplay(), (ElementSelector)event.getElement());
                } else {
                    ElementSelectorTableUI.this.view.clearResultVisualisation((ElementSelector)event.getElement());
                }
            }
        });
    }

    public Table getTable() {
        return this.viewer.getTable();
    }

    public ElementSelector getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection != null ? (ElementSelector)selection.getFirstElement() : null;
    }

    private CheckboxTableViewer createViewer() {
        return CheckboxTableViewer.newCheckList((Composite)this, (int)65540);
    }

    private void configureTable() {
        Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createNameColumn();
        this.createQueryColumn();
    }

    private void enableToolTips() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
    }

    private void setContentProvider() {
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof Collection)) {
                    return new Object[0];
                }
                return ((Collection)inputElement).toArray();
            }
        });
    }

    private TableViewerColumn createNameColumn() {
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.viewer, 0);
        column.getColumn().setText("Name");
        column.getColumn().setWidth(200);
        column.getColumn().setResizable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ElementSelector selector = (ElementSelector)element;
                return " " + selector.getName();
            }

            public Image getImage(Object element) {
                ElementSelector selector = (ElementSelector)element;
                float[] color = selector.getColor();
                if (color == null) {
                    return null;
                }
                RGB rgb = ElementSelectionTools.literalToColor(color).getRgb();
                PaletteData paletteData = new PaletteData(new RGB[]{new RGB(255, 255, 255), rgb});
                Image image = ElementSelectorTableUI.this.resourceManager.createImage(ImageDescriptor.createFromImageDataProvider(zoom -> {
                    int height = 8 * zoom / 100;
                    int width = 40 * zoom / 100;
                    ImageData imageData = new ImageData(width, height, 1, paletteData);
                    int x = 0;
                    while (x < width) {
                        int y = 0;
                        while (y < height) {
                            imageData.setPixel(x, y, 1);
                            ++y;
                        }
                        ++x;
                    }
                    return imageData;
                }));
                return image;
            }
        });
        return column;
    }

    private TableViewerColumn createQueryColumn() {
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.viewer, 0);
        column.getColumn().setText("Query");
        column.getColumn().setWidth(600);
        column.getColumn().setResizable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ElementSelector selector = (ElementSelector)element;
                return selector.getExpression();
            }
        });
        return column;
    }

    private void createSelectorListener(final Composite parent) {
        Simantics.getSession().asyncRequest((Read)new ElementSelectionTools.SelectionsRequest(), (SyncListener)new SyncListenerAdapter<Collection<ElementSelector>>(){

            public void execute(ReadGraph graph, Collection<ElementSelector> result) {
                parent.getDisplay().asyncExec(() -> ElementSelectorTableUI.this.viewer.setInput((Object)result));
            }

            public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
                LOGGER.error("Error getting element selector list", t);
            }

            public boolean isDisposed() {
                return ElementSelectorTableUI.this.isDisposed();
            }
        });
    }

    private void addSelectionListener() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
    }

    public void dispose() {
        this.view.dispose();
        super.dispose();
    }

    private final class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getViewer().getSelection();
            Display display = event.getViewer().getControl().getDisplay();
            ElementSelector query = (ElementSelector)selection.getFirstElement();
            ElementSelectorTableUI.this.view.performSelection(display, query);
            ElementSelectorTableUI.this.viewer.setChecked(selection.getFirstElement(), true);
        }
    }
}

