/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.district.selection.ElementSelectionResource;
import org.simantics.district.selection.ElementSelector;
import org.simantics.layer0.Layer0;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.color.Color;

public class ElementSelectionTools {
    public static float[] colorToLiteral(Color color) {
        return new float[]{(float)color.getB() / 255.0f, (float)color.getG() / 255.0f, (float)color.getR() / 255.0f, 1.0f};
    }

    public static Color literalToColor(float[] color) {
        return new Color((int)(color[2] * 255.0f), (int)(color[1] * 255.0f), (int)(color[0] * 255.0f));
    }

    public static final class SelectionElement
    extends AdaptableHintContext {
        public SelectionElement(IHintContext.Key[] keys) {
            super(keys);
        }

        public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
            Resource element = (Resource)this.getHint(SelectionHints.KEY_MAIN);
            if (contentType instanceof AnyResource) {
                return (T)element;
            }
            if (contentType instanceof AnyVariable) {
                AnyVariable type = (AnyVariable)contentType;
                try {
                    return (T)type.processor.syncRequest((Read)new ResourceRead<Variable>(element){

                        public Variable perform(ReadGraph graph) throws DatabaseException {
                            return ElementSelector.getVariableForElement((ReadGraph)graph, (Resource)this.resource);
                        }
                    });
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
            }
            return null;
        }
    }

    public static final class SelectionsRequest
    implements Read<Collection<ElementSelector>> {
        public Collection<ElementSelector> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
            Resource model = ActiveModels.getPossibleActiveModel((ReadGraph)graph, (Resource)Simantics.getProjectResource());
            if (model == null) {
                return Collections.emptyList();
            }
            List libs = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)ES.SelectionLibrary);
            if (libs.isEmpty()) {
                return Collections.emptyList();
            }
            Resource lib = (Resource)libs.get(0);
            ArrayList<ElementSelector> result = new ArrayList<ElementSelector>();
            for (Resource selection : graph.getObjects(lib, L0.ConsistsOf)) {
                if (!graph.isInstanceOf(selection, ES.Selection)) continue;
                result.add(ElementSelector.getSelector((RequestProcessor)graph, (Resource)selection));
            }
            return result;
        }
    }
}

