/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNEdgeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNEdgeBuilder.class);
    private Resource diagramResource;
    private IDiagram diagram;
    private GraphLayerManager glm;

    public DNEdgeBuilder(Resource diagramResource, IDiagram diagram) {
        this.diagramResource = diagramResource;
        this.diagram = diagram;
        IModifiableSynchronizationContext context = (IModifiableSynchronizationContext)diagram.getHint(SynchronizationHints.CONTEXT);
        this.glm = (GraphLayerManager)context.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
    }

    public static Optional<Resource> create(WriteGraph graph, Resource diagramResource, double[] start, double startElevation, double[] end, double endElevation, double[] detailedGeometryCoords, double padding) throws DatabaseException {
        Collection vertices = (Collection)graph.syncRequest((Read)new ObjectsWithType(diagramResource, Layer0.getInstance((ReadGraph)graph).ConsistsOf, DistrictNetworkResource.getInstance((ReadGraph)graph).Vertex));
        double halfPadding = padding / 2.0;
        Quadtree vv = new Quadtree();
        for (Resource vertex : vertices) {
            double[] coords = (double[])graph.getRelatedValue2(vertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            double x1 = coords[0] - halfPadding;
            double y1 = coords[1] - halfPadding;
            double x2 = coords[0] + halfPadding;
            double y2 = coords[1] + halfPadding;
            Envelope e = new Envelope(x1, x2, y1, y2);
            vv.insert(e, (Object)new DistrictNetworkUtil.ResourceVertex(vertex, coords, false));
        }
        return DNEdgeBuilder.create(graph, vv, diagramResource, null, start, startElevation, end, endElevation, detailedGeometryCoords, padding, true);
    }

    public static Optional<Resource> create(WriteGraph graph, Quadtree vertices, Resource diagramResource, Resource mapping, double[] start, double startElevation, double[] end, double endElevation, double[] detailedGeometryCoords, double padding, boolean writeElevationToEdgeFromPoints) throws DatabaseException {
        Resource endVertex;
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource startVertex = DNEdgeBuilder.getOrCreateVertex(graph, diagramResource, vertices, start, startElevation, padding, null);
        if (startVertex.equals(endVertex = DNEdgeBuilder.getOrCreateVertex(graph, diagramResource, vertices, end, endElevation, padding, startVertex))) {
            LOGGER.info("Circular edges are not supported, startVertex: {}, endVertex: {}", (Object)startVertex, (Object)endVertex);
            return Optional.empty();
        }
        Resource edge = DNEdgeBuilder.getOrCreateEdge(graph, diagramResource, mapping, detailedGeometryCoords);
        if (writeElevationToEdgeFromPoints) {
            graph.claimLiteral(edge, DN.Edge_HasElevation, (Object)DNEdgeBuilder.calculateElevationFromVertices(graph, startVertex, endVertex), (Binding)Bindings.DOUBLE);
        }
        graph.claim(edge, DN.HasStartVertex, startVertex);
        graph.claim(edge, DN.HasEndVertex, endVertex);
        return Optional.of(edge);
    }

    private static double calculateElevationFromVertices(WriteGraph graph, Resource startVertex, Resource endVertex) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Double startElevation = (Double)graph.getPossibleRelatedValue(startVertex, DN.Vertex_HasElevation, (Binding)Bindings.DOUBLE);
        Double endElevation = (Double)graph.getPossibleRelatedValue(endVertex, DN.Vertex_HasElevation, (Binding)Bindings.DOUBLE);
        if (startElevation != null && endElevation != null) {
            return (startElevation + endElevation) / 2.0;
        }
        return 0.0;
    }

    public void create(WriteGraph graph, double[] start, double startElevation, double[] end, double endElevation, double[] detailedGeometryCoords, double padding) throws DatabaseException {
        Optional<Resource> edge = DNEdgeBuilder.create(graph, this.diagramResource, start, startElevation, end, endElevation, detailedGeometryCoords, padding);
        if (this.glm != null) {
            this.putOnActiveLayer(graph, edge.get());
        }
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Added edge " + edge.get()));
        graph.markUndoPoint();
    }

    private void putOnActiveLayer(WriteGraph graph, Resource res) throws DatabaseException {
        this.glm.removeFromAllLayers(graph, res);
        this.glm.putElementOnVisibleLayers(this.diagram, graph, res);
    }

    private static Resource getOrCreateVertex(WriteGraph graph, Resource diagramResource, Quadtree qtree, double[] coords, double elevation, double padding, Resource startVertex) throws DatabaseException {
        List result;
        Resource vertex = null;
        double halfPadding = padding / 2.0;
        double maxDistance = Double.MAX_VALUE;
        double x1 = coords[0] - halfPadding;
        double y1 = coords[1] - halfPadding;
        double x2 = coords[0] + halfPadding;
        double y2 = coords[1] + halfPadding;
        Envelope e = new Envelope(x1, x2, y1, y2);
        List vertices = result = qtree.query(e);
        for (DistrictNetworkUtil.ResourceVertex vertx : vertices) {
            double dist;
            Rectangle2D.Double existing = new Rectangle2D.Double(vertx.coords[0] - halfPadding, vertx.coords[1] - halfPadding, padding, padding);
            Rectangle2D.Double tobecreated = new Rectangle2D.Double(x1, y1, padding, padding);
            if (!existing.intersects(tobecreated) || !((dist = Math.sqrt(Math.pow(coords[0] - vertx.coords[0], 2.0) + Math.pow(coords[1] - vertx.coords[1], 2.0))) <= maxDistance) || vertx.vertex == startVertex) continue;
            vertex = vertx.vertex;
            maxDistance = dist;
        }
        if (vertex == null) {
            vertex = DistrictNetworkUtil.createVertex(graph, diagramResource, coords, elevation);
            qtree.insert(e, (Object)new DistrictNetworkUtil.ResourceVertex(vertex, coords, false));
        }
        return vertex;
    }

    private static Resource getOrCreateEdge(WriteGraph graph, Resource diagramResource, Resource mapping, double[] detailedGeometryCoords) throws DatabaseException {
        return DistrictNetworkUtil.createEdge(graph, diagramResource, mapping, detailedGeometryCoords);
    }
}

