/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.wms;

import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;

public class WMSGetMapQuery {
    String srs = "EPSG:4326";
    int width;
    int height;
    Rectangle2D bbox;
    String[] styles;
    String[] layers;
    String format;

    public WMSGetMapQuery(int width, int height, Rectangle2D bbox, String format, String ... layers) throws MalformedURLException {
        this.width = width;
        this.height = height;
        this.bbox = bbox;
        this.format = format;
        this.layers = layers;
    }

    public void setSpatialReferenceSystem(String srs) {
        this.srs = srs;
    }

    public void setStyles(String ... styles) {
        this.styles = styles;
    }

    public void setLayers(String ... layers) {
        this.layers = layers;
    }

    public String toString() {
        if (this.layers.length == 0) {
            throw new IllegalStateException("0 layers defined");
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("request=GetMap");
        sb.append("&service=WMS");
        sb.append("&layers=");
        sb.append(this.layers[0]);
        int i = 1;
        while (i < this.layers.length) {
            sb.append(',');
            sb.append(this.layers[i]);
            ++i;
        }
        sb.append("&srs=");
        sb.append(this.srs);
        sb.append("&width=");
        sb.append(this.width);
        sb.append("&height=");
        sb.append(this.height);
        sb.append("&bbox=");
        sb.append(this.bbox.getMinX());
        sb.append(',');
        sb.append(this.bbox.getMinY());
        sb.append(',');
        sb.append(this.bbox.getMaxX());
        sb.append(',');
        sb.append(this.bbox.getMaxY());
        sb.append("&format=");
        sb.append(this.format);
        sb.append("&version=1.1.1");
        sb.append("&styles=");
        if (this.styles != null && this.styles.length > 0) {
            sb.append(this.styles[0]);
            i = 1;
            while (i < this.layers.length) {
                sb.append(',');
                sb.append(this.layers[i]);
                ++i;
            }
        }
        return sb.toString();
    }
}

