/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.sg;

import java.util.Locale;

class Formatting {
    private static final transient double EPSILON = 0.01;
    private static final transient double TRIM_THRESHOLD_MAX_VALUE = Math.pow(10.0, 4.0);
    private static final transient String[] SI_UNIT_LARGE_PREFIXES = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};

    Formatting() {
    }

    public static String formatValue(double value, int max, boolean removeTrailingZeros, FormatMode formatMode) {
        return Formatting.formatValue(value, max, removeTrailingZeros, formatMode, TRIM_THRESHOLD_MAX_VALUE);
    }

    public static String formatValue(double value, int max, boolean removeTrailingZeros, FormatMode formatMode, double trimThresholdMaxValue) {
        return Formatting.formatValue(value, max, removeTrailingZeros, formatMode, trimThresholdMaxValue, true);
    }

    public static String formatValue(double value, int max, boolean removeTrailingZeros, FormatMode formatMode, double trimThresholdMaxValue, boolean trimLargeValues) {
        int magnitude;
        int allowedDecimals = max;
        if (formatMode == FormatMode.LIMIT_DIGITS && (allowedDecimals -= Math.abs(magnitude = (int)Math.ceil(Math.log10(Math.abs(value))))) < 0) {
            allowedDecimals = 0;
        }
        String valueStr = String.format(Locale.US, "%." + allowedDecimals + "f", value);
        if (allowedDecimals > 0) {
            int dotIndex;
            if (removeTrailingZeros) {
                int trunc = valueStr.length() - 1;
                while (trunc > 0) {
                    char ch = valueStr.charAt(trunc);
                    if (ch == '.') {
                        valueStr = valueStr.substring(0, trunc);
                        break;
                    }
                    if (ch != '0') {
                        valueStr = valueStr.substring(0, trunc + 1);
                        break;
                    }
                    --trunc;
                }
            }
            if (Math.abs(value) + 0.01 > trimThresholdMaxValue && (dotIndex = valueStr.lastIndexOf(46)) > -1) {
                valueStr = valueStr.substring(0, dotIndex);
            }
        }
        if (valueStr.equals("-0")) {
            valueStr = "0";
        }
        if (trimLargeValues) {
            double trimValue = value;
            if (Math.abs(value) + 0.01 >= trimThresholdMaxValue) {
                int i = 0;
                while (Math.abs(trimValue) + 0.01 >= trimThresholdMaxValue) {
                    double trim = trimValue / 1000.0;
                    if (Math.abs(trim) - 0.01 < trimThresholdMaxValue) {
                        valueStr = valueStr.substring(0, valueStr.length() - (i + 1) * 3);
                        valueStr = String.valueOf(valueStr) + SI_UNIT_LARGE_PREFIXES[i];
                        break;
                    }
                    trimValue = trim;
                    ++i;
                }
            }
        }
        return valueStr;
    }

    public static enum FormatMode {
        LIMIT_DIGITS,
        LIMIT_DECIMALS;

    }
}

