/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.osm;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.simantics.maps.ProvisionException;
import org.simantics.maps.WebService;
import org.simantics.maps.internal.ImageUtil;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;
import org.simantics.maps.wms.ServiceException;

public class OSMTileProvider
implements ITileProvider {
    private WebService service;
    private int tileSize;

    public OSMTileProvider(WebService service, int tileSize) {
        this.service = service;
        this.tileSize = tileSize;
    }

    @Override
    public URI getSource() {
        return this.service.getURI();
    }

    @Override
    public Rectangle2D getExtent() {
        return new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
    }

    @Override
    public Image get(TileKey key) throws ProvisionException {
        int level = key.getLevel();
        int x = key.getX();
        int y = key.getY();
        double xTiles = Math.pow(2.0, level + 1);
        double yTiles = Math.pow(2.0, level);
        if (level < 0) {
            throw new IllegalArgumentException("invalid tile level " + level + " (tile=" + key + ")");
        }
        if (x < 0 || x >= (int)xTiles) {
            throw new IllegalArgumentException("tile x out of bounds " + x + " (tile=" + key + ")");
        }
        if (y < 0 || y >= (int)yTiles) {
            throw new IllegalArgumentException("tile y out of bounds " + y + " (tile=" + key + ")");
        }
        try {
            Rectangle2D.Double r = new Rectangle2D.Double(x, y, 10.0, 10.0);
            BufferedImage img = OSMTileProvider.getMap(this.service, this.tileSize, this.tileSize, r, "image/png", level);
            return img;
        }
        catch (MalformedURLException e) {
            throw new ProvisionException(e);
        }
        catch (IOException e) {
            throw new ProvisionException(e);
        }
    }

    public static BufferedImage getMap(WebService service, Dimension rasterSize, Rectangle2D bbox, String format, int level) throws MalformedURLException, IOException {
        return OSMTileProvider.getMap(service, rasterSize.width, rasterSize.height, bbox, format, level);
    }

    public static BufferedImage getMap(WebService service, int rasterWidth, int rasterHeight, Rectangle2D bbox, String format, int level) throws MalformedURLException, IOException {
        if (rasterWidth == 0 || rasterHeight == 0) {
            return new BufferedImage(0, 0, 2);
        }
        HttpURLConnection connection = null;
        try {
            String contentType;
            connection = service.openConnection(level + "/" + Math.round(bbox.getMinX()) + "/" + Math.round(bbox.getMinY()) + ".png", null);
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                System.err.println("Method failed: " + connection.getResponseMessage());
            }
            if ((contentType = connection.getHeaderField("Content-Type")) != null && contentType.equals(format)) {
                InputStream response = connection.getInputStream();
                BufferedImage img = ImageIO.read(response);
                if (img == null) {
                    throw new IIOException("ImageIO returned null, unable to decode stream as image data.");
                }
                BufferedImage bufferedImage = ImageUtil.toScreenCompatibleImage(img);
                return bufferedImage;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Response headers:\n");
            for (String h : connection.getHeaderFields().keySet()) {
                sb.append(h);
                sb.append(": ");
                sb.append(connection.getHeaderField(h));
                sb.append("\n");
            }
            String response = connection.getContent().toString();
            sb.append("Response body:\n");
            sb.append(response);
            throw new ServiceException("WMS GetMap request failed: " + connection.getURL().toString() + "\n" + sb.toString());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void setWebService(WebService webService) {
        this.service = webService;
    }
}

