/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.Command;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.server.io.IJSONObject;
import org.simantics.document.server.io.JSONObjectUtils;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.base.PostEventCommand;
import org.simantics.document.swt.core.base.WidgetContainer;
import org.simantics.document.swt.core.widget.ButtonSelectionListener;
import org.simantics.utils.datastructures.Pair;

public class ButtonWidget
extends LeafWidgetManager<Button> {
    @Override
    protected void doUpdateProperties(SWTDocument document, Button control, JSONObject object) {
        if (control.isDisposed()) {
            return;
        }
        String text = (String)object.getJSONField("text");
        control.setText(text);
        document.layout();
    }

    @Override
    protected Button doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
        Button label = new Button(parent, 0);
        return label;
    }

    @Override
    public IEventCommand eventCommand(SWTDocument document, JSONObject object, WidgetContainer widget, ICommand command, CommandContext p) {
        if ("onPress".equals(command.getCommand())) {
            CommandContextMutable context = new CommandContextImpl().merge(p);
            AbstractEventHandler onPress = (AbstractEventHandler)object.getJSONField("onPress");
            if (onPress == null) {
                return null;
            }
            return new PostEventCommand(document, (org.simantics.document.server.io.AbstractEventHandler)onPress, context);
        }
        return null;
    }

    public static class ButtonCommandManager
    implements CommandManager<SWTDocument, WidgetContainer<Button>> {
        public Collection<Object> updateCommandListeners(SWTDocument document, JSONObject object, WidgetContainer<Button> container) {
            WidgetData wd = document.getWidget(JSONObjectUtils.getId((IJSONObject)object));
            List commands = (List)object.getJSONField("commands");
            HashSet<Object> listeners = new HashSet<Object>();
            ArrayList<Pair<WidgetData, ICommand>> data = new ArrayList<Pair<WidgetData, ICommand>>();
            data.addAll(SWTViews.getTriggeredCommands(document, commands, "click"));
            data.addAll(SWTViews.getTriggeredCommands(document, commands, "eventOut"));
            data.add(new Pair((Object)wd, (Object)new Command("onPress")));
            ButtonSelectionListener listener = new ButtonSelectionListener(wd, data);
            Button button = container.getControl();
            if (!button.isDisposed()) {
                button.addSelectionListener((SelectionListener)listener);
                listeners.add(listener);
            }
            return listeners;
        }

        public void removeListener(WidgetContainer<Button> container, Object listener) {
            if (container.getControl().isDisposed()) {
                return;
            }
            if (listener instanceof SelectionListener) {
                container.getControl().removeSelectionListener((SelectionListener)listener);
            }
        }
    }
}

