/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.compressions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.compressions.Activator;
import org.simantics.compressions.CompressionCodec;

public final class Compressions {
    private static final Map<String, CompressionCodec> CODECS = new HashMap<String, CompressionCodec>();
    private static boolean initialized = false;
    public static final String LZ4 = "LZ4";
    public static final String FASTLZ = "FASTLZ";

    private static void collectCodecs() {
        try {
            Collection serv = Activator.getContext().getServiceReferences(CompressionCodec.class, null);
            for (ServiceReference service : serv) {
                CompressionCodec codec = (CompressionCodec)Activator.getContext().getService(service);
                CODECS.put(codec.getId(), codec);
            }
            initialized = true;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public static CompressionCodec get(String codecId) {
        CompressionCodec codec;
        if (!initialized) {
            Compressions.collectCodecs();
        }
        if ((codec = CODECS.get(codecId)) == null) {
            throw new IllegalArgumentException("No codec with id " + codecId + " installed");
        }
        return codec;
    }

    public static OutputStream write(String codecId, File file) throws FileNotFoundException {
        return Compressions.get(codecId).write(file);
    }

    public static InputStream read(String codecId, File file) throws FileNotFoundException {
        return Compressions.get(codecId).read(file);
    }
}

