/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.TransientUnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.NearestOwnerFinder;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.Functions;
import org.simantics.structural2.queries.ConnectionSet;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.structural2.variables.ActualConnectionDescriptor;
import org.simantics.structural2.variables.BrowseConnectionDescriptor;
import org.simantics.structural2.variables.ComponentConnectionDescriptor;
import org.simantics.structural2.variables.FixedConnection;
import org.simantics.structural2.variables.ResourceWithContext;
import org.simantics.structural2.variables.StandardProceduralChildVariable;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;

public class ConnectionBrowser {
    public static Collection<ResourceWithContext> findConnectedComponents(ReadGraph graph, Resource connection, Variable configuration) throws DatabaseException {
        ArrayList<ResourceWithContext> result = new ArrayList<ResourceWithContext>();
        THashSet visitedConnections = new THashSet();
        ConnectionBrowser.findConnectedComponents(graph, connection, configuration, result, (THashSet<Resource>)visitedConnections);
        return result;
    }

    private static void findConnectedComponents(ReadGraph graph, Resource connection, Variable configuration, ArrayList<ResourceWithContext> result, THashSet<Resource> visitedConnections) throws DatabaseException {
        if (visitedConnections.add((Object)connection)) {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Statement stat : graph.getStatements(connection, STR.Connects)) {
                Resource def;
                Resource component = stat.getObject();
                Resource relation = graph.getInverse(stat.getPredicate());
                Resource boundConnection = graph.getPossibleObject(relation, STR.IsBoundBy);
                Resource type = StructuralUtils.getPossibleComponentType(graph, configuration, component);
                Resource resource = def = type != null ? graph.getPossibleObject(type, STR.IsDefinedBy) : null;
                if (boundConnection != null && def != null) {
                    Variable newContext = configuration.browsePossible(graph, component);
                    Resource newComposite = ConnectionBrowser.getCompositeOfConnection(graph, boundConnection);
                    if (newContext == null || newComposite == null || (newContext = ConnectionBrowser.browse(graph, def, newContext, newComposite)) == null) continue;
                    ConnectionBrowser.findConnectedComponents(graph, boundConnection, newContext, result, visitedConnections);
                    continue;
                }
                Variable context = configuration.browsePossible(graph, component);
                if (context == null) continue;
                result.add(new ResourceWithContext(component, context));
            }
            for (Resource join : graph.getObjects(connection, STR.IsJoinedBy)) {
                for (Resource otherConnection : graph.getObjects(join, STR.Joins)) {
                    Variable sibling;
                    if (connection.equals(otherConnection)) continue;
                    Resource sourceComposite = ConnectionBrowser.getCompositeOfConnection(graph, connection);
                    Resource targetComposite = ConnectionBrowser.getCompositeOfConnection(graph, otherConnection);
                    if (sourceComposite == null || targetComposite == null || (sibling = ConnectionBrowser.browseSibling(graph, sourceComposite, configuration, targetComposite)) == null) continue;
                    ConnectionBrowser.findConnectedComponents(graph, otherConnection, sibling, result, visitedConnections);
                }
            }
            try {
                for (Resource relation : graph.getObjects(connection, STR.Binds)) {
                    Resource composite = ConnectionBrowser.getCompositeOfConnection(graph, connection);
                    if (composite == null) continue;
                    Variable curConfiguration = configuration;
                    while (!graph.hasStatement(composite, STR.Defines)) {
                        composite = graph.getSingleObject(composite, L0.PartOf);
                        curConfiguration = curConfiguration.getParent(graph);
                    }
                    Variable parent = curConfiguration.getParent(graph);
                    Resource component = curConfiguration.getRepresents(graph);
                    for (Resource c : graph.getObjects(component, relation)) {
                        ConnectionBrowser.findConnectedComponents(graph, c, parent, result, visitedConnections);
                    }
                }
            }
            catch (NoSingleResultException noSingleResultException) {
            }
            catch (MissingVariableException missingVariableException) {
            }
            catch (MissingVariableValueException missingVariableValueException) {}
        }
    }

    public static Collection<VariableConnectionPointDescriptor> drill(ReadGraph graph, VariableConnectionPointDescriptor pair) throws DatabaseException {
        Collection<Functions.InterfaceResolution> interfaceDescription = pair.getInterfaceDescription(graph);
        if (interfaceDescription != null && interfaceDescription.size() > 0) {
            Variable cp = pair.getVariable(graph);
            Variable context = cp.getParent(graph);
            String cpName = cp.getName(graph);
            ArrayList<VariableConnectionPointDescriptor> result = new ArrayList<VariableConnectionPointDescriptor>();
            for (Functions.InterfaceResolution r : interfaceDescription) {
                if (!r.interfaceName.equals(cpName)) continue;
                String path = Functions.resolveInterfacePath(graph, context, r.componentName, r.connectionPoint);
                result.add(new BrowseConnectionDescriptor(context, path));
            }
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        return Collections.singleton(pair);
    }

    static Variable resolve(ReadGraph graph, Variable base, Resource component) throws DatabaseException {
        Map map = (Map)graph.syncRequest((Read)new VariableChildren(graph, base), (AsyncProcedure)TransientCacheAsyncListener.instance());
        Variable result = (Variable)map.get(component);
        if (result != null) {
            return result;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(component, L0.PartOf);
        if (parent == null) {
            return null;
        }
        Variable v = ConnectionBrowser.resolve(graph, base, parent);
        if (v == null) {
            return null;
        }
        map = (Map)graph.syncRequest((Read)new VariableChildren(graph, v), (AsyncProcedure)TransientCacheAsyncListener.instance());
        return (Variable)map.get(component);
    }

    public static Collection<VariableConnectionPointDescriptor> climb(ReadGraph graph, Variable child, Resource cp, String subPath_) throws DatabaseException {
        boolean isStructural = false;
        Variable curConfiguration = child.getParent(graph);
        Collection<Functions.InterfaceResolution> interfaceDescription = Functions.computeInterfacePaths(graph, curConfiguration);
        if (interfaceDescription != null) {
            boolean bl = isStructural = interfaceDescription != Functions.BUILTIN_STRUCTURAL_CPS;
            if (interfaceDescription.size() > 0) {
                if (subPath_ == null) {
                    String childName = child.getName(graph);
                    for (Functions.InterfaceResolution r : interfaceDescription) {
                        Resource cp2;
                        Collection<VariableConnectionPointDescriptor> res;
                        if (!r.componentName.equals(childName) || !r.connectionPoint.equals(cp)) continue;
                        Variable pConn = curConfiguration.getPossibleProperty(graph, r.interfaceName);
                        if (pConn != null && (res = ConnectionBrowser.climb(graph, curConfiguration, cp2 = pConn.getPossiblePredicateResource(graph), null)) != null) {
                            return res;
                        }
                        return Collections.emptyList();
                    }
                } else {
                    throw new UnsupportedOperationException("");
                }
            }
        }
        if (child instanceof StandardProceduralChildVariable) {
            Variable conn = child.getPossibleProperty(graph, cp);
            FixedConnection fc = (FixedConnection)conn.getValue(graph);
            THashSet result = new THashSet(1 + fc.size());
            result.add(new ComponentConnectionDescriptor(child, cp));
            fc.addConnectionDescriptors(graph, curConfiguration, (Collection<VariableConnectionPointDescriptor>)result);
            return result;
        }
        Resource res = cp;
        Resource represents = child.getRepresents(graph);
        if (isStructural) {
            Collection conns = graph.getObjects(represents, res);
            HashSet<VariableConnectionPointDescriptor> result = new HashSet<VariableConnectionPointDescriptor>();
            for (Resource c : conns) {
                List rs = (List)graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, c), (AsyncProcedure)TransientCacheAsyncListener.instance());
                result.addAll((Collection)graph.syncRequest((Read)ConnectionVariables.forStructural(graph, curConfiguration, rs)));
            }
            return result;
        }
        Resource connection = graph.getPossibleObject(represents, res);
        if (connection != null) {
            List rs = (List)graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, connection), (AsyncProcedure)TransientCacheAsyncListener.instance());
            return (Collection)graph.syncRequest((Read)ConnectionVariables.forConfiguration(graph, curConfiguration, rs));
        }
        Collection conns = graph.getObjects(represents, res);
        HashSet<VariableConnectionPointDescriptor> result = new HashSet<VariableConnectionPointDescriptor>();
        for (Resource c : conns) {
            List rs = (List)graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, c), (AsyncProcedure)TransientCacheAsyncListener.instance());
            result.addAll((Collection)graph.syncRequest((Read)ConnectionVariables.forConfiguration(graph, curConfiguration, rs)));
        }
        return result;
    }

    public static void reportDescriptor(ReadGraph graph, VariableConnectionPointDescriptor d) throws DatabaseException {
        if (d instanceof ActualConnectionDescriptor) {
            ActualConnectionDescriptor d2 = (ActualConnectionDescriptor)d;
            System.err.println("--ActualConnectionPointDescriptor2");
            System.err.println("---root: " + d2.root.getURI(graph));
            System.err.println("---component: " + graph.getPossibleURI(d2.component));
            System.err.println("---type: " + graph.getPossibleURI(d2.componentType));
            System.err.println("---cp: " + graph.getPossibleURI(d2.cp));
            System.err.println("---var: " + d2.getVariable(graph).getURI(graph));
        }
    }

    public static Variable browse(ReadGraph graph, Resource root, Variable rootContext, Resource target) throws DatabaseException {
        if (target.equals(root)) {
            return rootContext;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(target, L0.HasName, (Binding)Bindings.STRING);
        Resource parent = graph.getPossibleObject(target, L0.PartOf);
        if (name == null || parent == null) {
            return null;
        }
        Variable parentVariable = ConnectionBrowser.browse(graph, root, rootContext, parent);
        if (parentVariable == null) {
            return null;
        }
        return parentVariable.getPossibleChild(graph, name);
    }

    public static Variable browseSibling(ReadGraph graph, Resource source, Variable sourceContext, Resource target) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        THashMap sourceMap = new THashMap();
        while (source != null && sourceContext != null) {
            sourceMap.put((Object)source, (Object)sourceContext);
            source = graph.getPossibleObject(source, L0.PartOf);
            sourceContext = sourceContext.getParent(graph);
        }
        return ConnectionBrowser.browseSibling(graph, (THashMap<Resource, Variable>)sourceMap, target);
    }

    private static Variable browseSibling(ReadGraph graph, THashMap<Resource, Variable> sourceMap, Resource target) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Variable result = (Variable)sourceMap.get((Object)target);
        if (result != null) {
            return result;
        }
        String name = (String)graph.getPossibleRelatedValue(target, L0.HasName, (Binding)Bindings.STRING);
        Resource parent = graph.getPossibleObject(target, L0.PartOf);
        if (name == null || parent == null) {
            return null;
        }
        Variable parentVariable = ConnectionBrowser.browseSibling(graph, sourceMap, parent);
        if (parentVariable == null) {
            return null;
        }
        return parentVariable.getPossibleChild(graph, name);
    }

    public static Resource getCompositeOfConnection(ReadGraph graph, Resource connection) throws DatabaseException {
        Resource diagramToComposite;
        Resource diagram;
        Resource diagramConnection;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource component : graph.getObjects(connection, STR.Connects)) {
            Iterator iterator = graph.getObjects(component, L0.PartOf).iterator();
            if (!iterator.hasNext()) continue;
            Resource composite = (Resource)iterator.next();
            return composite;
        }
        Resource connToDiagramConn = graph.getPossibleResource("http://www.simantics.org/Modeling-1.2/ConnectionToDiagramConnection");
        if (connToDiagramConn != null && (diagramConnection = graph.getPossibleObject(connection, connToDiagramConn)) != null && (diagram = graph.getPossibleObject(diagramConnection, L0.PartOf)) != null && (diagramToComposite = graph.getPossibleResource("http://www.simantics.org/Modeling-1.2/DiagramToComposite")) != null) {
            return graph.getPossibleObject(diagram, diagramToComposite);
        }
        return null;
    }

    public static Collection<VariableConnectionPointDescriptor> flatten(ReadGraph graph, Variable child, Resource cp, Resource relationType) throws DatabaseException {
        if (relationType == null) {
            return (Collection)graph.syncRequest((Read)new Flatten(child, cp));
        }
        return ConnectionBrowser.doFlatten(graph, child, cp, relationType);
    }

    public static Collection<VariableConnectionPointDescriptor> doFlatten(ReadGraph graph, Variable child, Resource cp, Resource relationType) throws DatabaseException {
        Set result = null;
        Set needDrill = null;
        Collection<VariableConnectionPointDescriptor> climbed = ConnectionBrowser.climb(graph, child, cp, null);
        for (VariableConnectionPointDescriptor desc : climbed) {
            if (!desc.isLeaf(graph)) {
                if (needDrill == null) {
                    needDrill = new THashSet(climbed.size());
                }
                needDrill.add(desc);
                continue;
            }
            if (relationType != null && !ConnectionBrowser.filterByRelationType(graph, desc, relationType)) continue;
            if (result == null) {
                result = new THashSet(climbed.size());
            }
            result.add(desc);
        }
        if (needDrill != null) {
            for (VariableConnectionPointDescriptor top : needDrill) {
                Collection<VariableConnectionPointDescriptor> drilled = ConnectionBrowser.drill(graph, top);
                if (drilled == null) continue;
                for (VariableConnectionPointDescriptor drill : drilled) {
                    if (relationType != null && !ConnectionBrowser.filterByRelationType(graph, drill, relationType)) continue;
                    if (result == null) {
                        result = new THashSet(climbed.size());
                    }
                    result.add(drill);
                }
            }
        }
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    private static boolean filterByRelationType(ReadGraph graph, VariableConnectionPointDescriptor desc, Resource relationType) throws DatabaseException {
        Resource predicateResource = desc.getConnectionPointResource(graph);
        return predicateResource != null && graph.isInstanceOf(predicateResource, relationType);
    }

    private static String safeURI(ReadGraph graph, Variable v) {
        if (v == null) {
            return "null variable";
        }
        try {
            return v.getURI(graph);
        }
        catch (DatabaseException databaseException) {
            return v.toString();
        }
    }

    static class ChildMapOfVariable
    extends VariableRead<Map<Resource, Variable>> {
        public ChildMapOfVariable(Variable variable) {
            super(variable);
        }

        public Map<Resource, Variable> perform(ReadGraph graph) throws DatabaseException {
            HashMap<Resource, Variable> result = new HashMap<Resource, Variable>();
            for (Variable child : this.variable.getChildren(graph)) {
                Resource represents = child.getPossibleRepresents(graph);
                if (represents == null) continue;
                result.put(represents, child);
            }
            return result;
        }
    }

    public static class ConnectionComponentsWithAncestor
    extends TransientUnaryRead<Resource, List<Resource>> {
        private final List<Resource> result;

        public ConnectionComponentsWithAncestor(ReadGraph graph, Resource conn) throws DatabaseException {
            this(graph, conn, null);
        }

        public ConnectionComponentsWithAncestor(ReadGraph graph, QueryControl qc, Resource conn, List<Resource> result) throws DatabaseException {
            super(graph, qc, (Object)conn);
            this.result = result;
        }

        public ConnectionComponentsWithAncestor(ReadGraph graph, Resource conn, List<Resource> result) throws DatabaseException {
            super(graph, (Object)conn);
            this.result = result;
        }

        private ConnectionSet connSet(ReadGraph graph, Resource r) throws DatabaseException {
            ConnectionSet cs = new ConnectionSet(graph);
            cs.addConnection(graph, r);
            return cs;
        }

        public List<Resource> perform(ReadGraph graph, Resource resource) throws DatabaseException {
            if (this.result != null) {
                return this.result;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            CollectionSupport colls = (CollectionSupport)graph.getService(CollectionSupport.class);
            THashSet ancestorGenerators = new THashSet();
            Set parts = colls.createSet();
            ConnectionSet cs = this.connSet(graph, resource);
            for (Resource connRes : cs.getConnections()) {
                for (Statement stm : graph.getStatements(connRes, STR.Connects)) {
                    Resource component = stm.getObject();
                    Resource parent = graph.getPossibleObject(component, L0.PartOf);
                    if (parent == null || graph.isInstanceOf(component, ModelingResources.getInstance((ReadGraph)graph).ReferenceElement)) continue;
                    ancestorGenerators.add((Object)parent);
                }
                parts.add(connRes);
            }
            for (Resource join : cs.getJoins()) {
                parts.add(join);
                for (Resource composite : graph.getObjects(join, STR.JoinsComposite)) {
                    ancestorGenerators.add((Object)composite);
                }
            }
            Resource ancestor = ancestorGenerators.size() == 1 ? (Resource)ancestorGenerators.iterator().next() : NearestOwnerFinder.getNearestOwnerFromDirectOwners((ReadGraph)graph, (Collection)ancestorGenerators);
            List result = colls.createList();
            result.add(ancestor);
            result.addAll(colls.asSortedList((Collection)parts));
            if (this.parameter != WITH_PARENT) {
                int i = 1;
                while (i < result.size()) {
                    Resource r = (Resource)result.get(i);
                    if (!r.equals(resource)) {
                        graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, r, result), (AsyncProcedure)TransientCacheAsyncListener.instance());
                    }
                    ++i;
                }
            }
            return result;
        }
    }

    public static class ConnectionVariables
    extends BinaryRead<Variable, List<Resource>, Collection<VariableConnectionPointDescriptor>> {
        private ConnectionVariables(Variable parameter1, List<Resource> parameter2) {
            super((Object)parameter1, parameter2);
        }

        public static ConnectionVariables forConfiguration(ReadGraph graph, Variable configuration, List<Resource> rs) throws DatabaseException {
            return new ConnectionVariables(ConnectionVariables.parent(graph, configuration, rs.get(0)), rs);
        }

        public static ConnectionVariables forStructural(ReadGraph graph, Variable configuration, List<Resource> rs) throws DatabaseException {
            return new ConnectionVariables(configuration, rs);
        }

        private static Variable parent(ReadGraph graph, Variable configuration, Resource ancestor) throws DatabaseException {
            Variable v = configuration;
            Resource represents = v.getRepresents(graph);
            while (!represents.equals(ancestor)) {
                if ((v = v.getParent(graph)) == null) {
                    throw new DatabaseException("parent representing ancestor not found for variable, configuration=" + ConnectionBrowser.safeURI(graph, configuration) + ", ancestor=" + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)ancestor));
                }
                represents = v.getRepresents(graph);
            }
            return v;
        }

        public Collection<VariableConnectionPointDescriptor> perform(ReadGraph graph) throws DatabaseException {
            if (this.parameter == null) {
                return Collections.emptyList();
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            ArrayList<ActualConnectionDescriptor> result = null;
            int i = 1;
            while (i < ((List)this.parameter2).size()) {
                Resource connRes = (Resource)((List)this.parameter2).get(i);
                for (Statement stm : graph.getStatements(connRes, STR.Connects)) {
                    Resource type;
                    String componentName;
                    Variable possibleChild;
                    Resource component = stm.getObject();
                    Resource connectionPoint = graph.getInverse(stm.getPredicate());
                    if (result == null) {
                        result = new ArrayList<ActualConnectionDescriptor>();
                    }
                    if ((possibleChild = ((Variable)this.parameter).getPossibleChild(graph, componentName = (String)graph.getRelatedValue(component, L0.HasName, (Binding)Bindings.STRING))) != null) {
                        type = possibleChild.getPossibleType(graph, STR.Component);
                        if (type != null) {
                            result.add(new ActualConnectionDescriptor((Variable)this.parameter, component, type, connectionPoint));
                            continue;
                        }
                        throw new DatabaseException("Child does not have a structural type: " + possibleChild.getURI(graph));
                    }
                    type = graph.getPossibleType(component, STR.Component);
                    if (type != null) {
                        result.add(new ActualConnectionDescriptor((Variable)this.parameter, component, type, connectionPoint));
                        continue;
                    }
                    throw new DatabaseException("Child with name " + componentName + " does not have a structural type: " + ((Variable)this.parameter).getURI(graph));
                }
                ++i;
            }
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }
    }

    static class Flatten
    extends BinaryRead<Variable, Resource, Collection<VariableConnectionPointDescriptor>> {
        public Flatten(Variable parameter1, Resource parameter2) {
            super((Object)parameter1, (Object)parameter2);
        }

        public Collection<VariableConnectionPointDescriptor> perform(ReadGraph graph) throws DatabaseException {
            return ConnectionBrowser.doFlatten(graph, (Variable)this.parameter, (Resource)this.parameter2, null);
        }
    }

    static class IsLeafType
    extends ResourceRead<Boolean> {
        protected IsLeafType(Resource type) {
            super(type);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            StructuralUtils.StructuralComponentClass clazz = StructuralUtils.StructuralComponentClass.get(graph, this.resource);
            return StructuralUtils.StructuralComponentClass.PRIMITIVE.equals((Object)clazz);
        }
    }

    public static class JoinConnections
    extends ResourceRead<Collection<Resource>> {
        public JoinConnections(Resource join) {
            super(join);
        }

        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
            ConnectionSet cs = new ConnectionSet(graph);
            cs.addJoin(graph, this.resource);
            return cs.getConnections();
        }
    }

    public static final class VariableChildren
    extends TransientUnaryRead<Variable, Map<Resource, Variable>> {
        public VariableChildren(ReadGraph graph, Variable variable) throws DatabaseException {
            super(graph, (Object)variable);
        }

        public VariableChildren(ReadGraph graph, QueryControl qc, Variable variable) throws DatabaseException {
            super(graph, qc, (Object)variable);
        }

        public Map<Resource, Variable> perform(ReadGraph graph, Variable parameter) throws DatabaseException {
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Map result = (Map)cs.createMap(Variable.class);
            for (Variable child : parameter.getChildren(graph)) {
                Resource represents = child.getPossibleRepresents(graph);
                if (represents == null) continue;
                result.put(represents, child);
            }
            return result;
        }
    }
}

