/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural2.ConnectionImpl2;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.Connection2;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;

public class ConnectionImpl
implements Connection {
    private final Variable component;
    private final Resource predicate;

    public ConnectionImpl(Variable component, Resource predicate) {
        this.component = component;
        this.predicate = predicate;
    }

    @Override
    public Collection<Variable> getConnectionPoints(ReadGraph graph, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, this.component, this.predicate, relationType)) {
            result.add(desc.getVariable(graph));
        }
        return result;
    }

    @Override
    public Collection<String> getConnectionPointURIs(ReadGraph graph, Resource relationType) throws DatabaseException {
        THashSet result = new THashSet();
        for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, this.component, this.predicate, relationType)) {
            result.add(desc.getURI(graph));
        }
        return result;
    }

    @Override
    public Collection<VariableConnectionPointDescriptor> getConnectionPointDescriptors(ReadGraph graph, Resource relationType) throws DatabaseException {
        return ConnectionBrowser.flatten(graph, this.component, this.predicate, relationType);
    }

    @Override
    public Connection2 getConnection2() {
        return new ConnectionImpl2(this.predicate);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionImpl other = (ConnectionImpl)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        return !(this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate));
    }
}

