/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import org.simantics.diagram.elements.AnimatedSVGNode;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.ProvisionException;

public class AnimatedSVGImage
implements Image {
    static EnumSet<Image.Feature> caps = EnumSet.of(Image.Feature.Vector);
    private Rectangle2D bounds;
    private final String nodeIdentifier;
    private final String svgDocument;
    private final String svgScript;
    private Point targetSize;

    public static IFactory<Image> createFactoryFromString(String nodeIdentifier, String svgDocument) {
        return AnimatedSVGImage.createFactoryFromString(svgDocument, null);
    }

    public static IFactory<Image> createFactoryFromString(String nodeIdentifier, String svgDocument, String svgScript, Point targetSize) {
        return new AnimatedSVGFactory(nodeIdentifier, svgDocument, svgScript, targetSize);
    }

    public AnimatedSVGImage(String nodeIdentifier, String svgDocument, String svgScript, Point targetSize) {
        if (nodeIdentifier == null) {
            throw new NullPointerException("nodeIdentifier is null");
        }
        if (svgDocument == null) {
            throw new NullPointerException("svgDocument is null");
        }
        if (svgScript == null) {
            throw new NullPointerException("svgScript is null");
        }
        this.nodeIdentifier = nodeIdentifier;
        this.svgDocument = svgDocument;
        this.svgScript = svgScript;
        this.targetSize = targetSize;
    }

    public Node init(G2DParentNode parent) {
        AnimatedSVGNode node = (AnimatedSVGNode)((Object)parent.getOrCreateNode(this.nodeIdentifier, AnimatedSVGNode.class));
        node.setData(this.svgDocument);
        node.setScript(this.svgScript);
        node.setTargetSize(this.targetSize);
        node.useMipMap(true);
        return node;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = SVGNode.getBounds((String)this.svgDocument);
        }
        return this.bounds;
    }

    public Shape getOutline() {
        return this.getBounds();
    }

    public void addImageListener(Image.ImageListener listener) {
    }

    public EnumSet<Image.Feature> getFeatures() {
        return caps;
    }

    public void removeImageListener(Image.ImageListener listener) {
    }

    static class AnimatedSVGFactory
    implements IFactory<Image> {
        String nodeIdentifier;
        String document;
        String script;
        Point targetSize;

        public AnimatedSVGFactory(String nodeIdentifier, String document, String script, Point referenceSize) {
            if (nodeIdentifier == null) {
                throw new NullPointerException("nodeIdentifier is null");
            }
            if (document == null) {
                throw new NullPointerException("document is null");
            }
            if (script == null) {
                throw new NullPointerException("script is null");
            }
            this.nodeIdentifier = nodeIdentifier;
            this.document = document;
            this.script = script;
            this.targetSize = referenceSize;
        }

        public Image get() throws ProvisionException {
            return new AnimatedSVGImage(this.nodeIdentifier, this.document, this.script, this.targetSize);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            AnimatedSVGFactory other = (AnimatedSVGFactory)obj;
            if (!this.nodeIdentifier.equals(other.nodeIdentifier)) {
                return false;
            }
            if (this.targetSize != null ? !this.targetSize.equals(other.targetSize) : other.targetSize != null) {
                return false;
            }
            return this.document.equals(other.document);
        }

        public int hashCode() {
            return this.nodeIdentifier.hashCode() * 31 + this.document.hashCode() + 123;
        }
    }
}

