/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.connection;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Parent;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.ConfigurableEdgeVisuals;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.ParentImpl;
import org.simantics.g2d.element.handler.impl.ShapePick;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.elementclass.PlainElementPropertySetter;
import org.simantics.g2d.elementclass.connection.EdgeSceneGraph;
import org.simantics.utils.datastructures.hints.IHintContext;

public class EdgeClass {
    public static final ElementClass STRAIGHT = ElementClass.compile(EdgeSceneGraph.INSTANCE, EdgeHandler.INSTANCE, ConfigurableEdgeVisuals.DEFAULT, FillColorImpl.RED, FixedTransform.INSTANCE, ShapePick.INSTANCE, ConnectionSelectionOutline.INSTANCE, SimpleElementLayers.INSTANCE, ParentImpl.INSTANCE, new PlainElementPropertySetter(EdgeSceneGraph.KEY_SG_NODE)).setId("EdgeClass.STRAIGHT");

    public static class ControlPointKey
    extends IHintContext.Key {
        public final int index;
        final int hash;

        public ControlPointKey(int index) {
            this.index = index;
            this.hash = ((Object)((Object)this)).getClass().hashCode() ^ index ^ 0x33DF677;
        }

        public boolean isValueAccepted(Object value) {
            return IElement.class.isInstance(value);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ControlPointKey other = (ControlPointKey)((Object)obj);
            return other.index == this.index;
        }
    }

    public static class EdgeHandler
    implements BendsHandler,
    Outline,
    LifeCycle,
    InternalSize {
        private static final long serialVersionUID = -5949432471958957382L;
        public static final EdgeHandler INSTANCE = new EdgeHandler();
        public static final IHintContext.Key KEY_PATH = new IHintContext.KeyOf(Path2D.class, "PATH");
        public static final IHintContext.Key KEY_BOUNDS = new IHintContext.KeyOf(Rectangle2D.class, "BOUNDS");
        public static final IHintContext.Key KEY_ANGLETYPE = new IHintContext.KeyOf(BendsHandler.AngleType.class);
        public static final IHintContext.Key KEY_BENDS = new IHintContext.KeyOf(ArrayList.class, "BENDS");

        @Override
        public void setAngleType(IElement e, BendsHandler.AngleType angleType) {
            e.setHint(KEY_ANGLETYPE, (Object)angleType);
        }

        @Override
        public BendsHandler.AngleType getAngleType(IElement e) {
            return (BendsHandler.AngleType)((Object)e.getHint(KEY_ANGLETYPE));
        }

        @Override
        public Shape getElementShape(IElement e) {
            return (Shape)e.getHint(KEY_PATH);
        }

        @Override
        public void onElementActivated(IDiagram d, IElement e) {
            this.update(e);
        }

        @Override
        public void onElementCreated(IElement e) {
            e.setHint(KEY_PATH, new Path2D.Double(1, 2));
            e.setHint(KEY_ANGLETYPE, (Object)BendsHandler.AngleType.RightAngled);
            e.setHint(KEY_BOUNDS, new Rectangle2D.Double());
            e.setHint(KEY_BENDS, new ArrayList(2));
        }

        @Override
        public void onElementDestroyed(IElement e) {
        }

        private void update(IElement e) {
            EdgeSceneGraph sg = e.getElementClass().getAtMostOneItemOfClass(EdgeSceneGraph.class);
            if (sg != null) {
                sg.update(e);
            }
        }

        @Override
        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        @Override
        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            Rectangle2D rect = (Rectangle2D)e.getHint(KEY_BOUNDS);
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            if (rect != null) {
                size.setFrame(rect);
            }
            return rect;
        }

        @Override
        public BendsHandler.Bend addBend(IElement e, int index, Point2D pos) {
            ArrayList list = (ArrayList)e.getHint(KEY_BENDS);
            BendImpl b = new BendImpl();
            b.pos = new Point2D.Double(pos.getX(), pos.getY());
            list.add(index, b);
            this.update(e);
            return b;
        }

        @Override
        public void getBendPosition(IElement e, BendsHandler.Bend b, Point2D pos) {
            pos.setLocation(((BendImpl)b).pos);
        }

        @Override
        public int getBendsCount(IElement e) {
            ArrayList list = (ArrayList)e.getHint(KEY_BENDS);
            return list.size();
        }

        @Override
        public void getBends(IElement e, List<BendsHandler.Bend> bends) {
            ArrayList list = (ArrayList)e.getHint(KEY_BENDS);
            bends.addAll(list);
        }

        @Override
        public boolean removeBend(IElement e, BendsHandler.Bend b) {
            ArrayList list = (ArrayList)e.getHint(KEY_BENDS);
            return list.remove(b);
        }

        @Override
        public Path2D getPath(IElement e) {
            return (Path2D)e.getHint(KEY_PATH);
        }

        @Override
        public void setPath(IElement e, Path2D path) {
            e.setHint(KEY_PATH, path);
            e.setHint(KEY_BOUNDS, path.getBounds2D());
            this.update(e);
        }

        @Override
        public void moveBend(IElement e, BendsHandler.Bend b, Point2D pos) {
            BendImpl bi = (BendImpl)b;
            if (bi.pos.equals(pos)) {
                return;
            }
            bi.pos.setLocation(pos);
            this.update(e);
        }

        public static class BendImpl
        implements BendsHandler.Bend {
            Point2D pos;
        }
    }

    public static class FixedTransform
    implements Transform,
    Move {
        private static final long serialVersionUID = 2287402413442694915L;
        public static final FixedTransform INSTANCE = new FixedTransform();
        public static final AffineTransform IDENTITY = new AffineTransform();

        @Override
        public AffineTransform getTransform(IElement e) {
            Parent p;
            AffineTransform local = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            if (local == null) {
                local = IDENTITY;
            }
            if ((p = e.getElementClass().getAtMostOneItemOfClass(Parent.class)) == null) {
                return local;
            }
            IElement parentElement = p.getParent(e);
            if (parentElement == null) {
                return local;
            }
            AffineTransform parentTransform = parentElement.getElementClass().getSingleItem(Transform.class).getTransform(parentElement);
            if (parentTransform.isIdentity()) {
                return local;
            }
            AffineTransform result = new AffineTransform(local);
            result.preConcatenate(parentTransform);
            return result;
        }

        @Override
        public void setTransform(IElement e, AffineTransform at) {
            assert (at != null);
            e.setHint(ElementHints.KEY_TRANSFORM, at);
        }

        @Override
        public Point2D getPosition(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            if (at == null) {
                return new Point2D.Double();
            }
            return new Point2D.Double(at.getTranslateX(), at.getTranslateY());
        }

        @Override
        public void moveTo(IElement e, double x, double y) {
        }
    }
}

